/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureType;
import software.amazon.awssdk.services.ec2.model.ArchitectureTypeSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.services.ec2.model.VirtualizationTypeSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstanceTypesFromInstanceRequirementsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetInstanceTypesFromInstanceRequirementsRequest> {
    private static final SdkField<List<String>> ARCHITECTURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ArchitectureTypes").getter(GetInstanceTypesFromInstanceRequirementsRequest.getter(GetInstanceTypesFromInstanceRequirementsRequest::architectureTypesAsStrings)).setter(GetInstanceTypesFromInstanceRequirementsRequest.setter(Builder::architectureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitectureType").unmarshallLocationName("ArchitectureType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VIRTUALIZATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VirtualizationTypes").getter(GetInstanceTypesFromInstanceRequirementsRequest.getter(GetInstanceTypesFromInstanceRequirementsRequest::virtualizationTypesAsStrings)).setter(GetInstanceTypesFromInstanceRequirementsRequest.setter(Builder::virtualizationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").unmarshallLocationName("VirtualizationType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(GetInstanceTypesFromInstanceRequirementsRequest.getter(GetInstanceTypesFromInstanceRequirementsRequest::instanceRequirements)).setter(GetInstanceTypesFromInstanceRequirementsRequest.setter(Builder::instanceRequirements)).constructor(InstanceRequirementsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("InstanceRequirements").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetInstanceTypesFromInstanceRequirementsRequest.getter(GetInstanceTypesFromInstanceRequirementsRequest::maxResults)).setter(GetInstanceTypesFromInstanceRequirementsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInstanceTypesFromInstanceRequirementsRequest.getter(GetInstanceTypesFromInstanceRequirementsRequest::nextToken)).setter(GetInstanceTypesFromInstanceRequirementsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_TYPES_FIELD, VIRTUALIZATION_TYPES_FIELD, INSTANCE_REQUIREMENTS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> architectureTypes;
    private final List<String> virtualizationTypes;
    private final InstanceRequirementsRequest instanceRequirements;
    private final Integer maxResults;
    private final String nextToken;

    private GetInstanceTypesFromInstanceRequirementsRequest(BuilderImpl builder) {
        super(builder);
        this.architectureTypes = builder.architectureTypes;
        this.virtualizationTypes = builder.virtualizationTypes;
        this.instanceRequirements = builder.instanceRequirements;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<ArchitectureType> architectureTypes() {
        return ArchitectureTypeSetCopier.copyStringToEnum(this.architectureTypes);
    }

    public final boolean hasArchitectureTypes() {
        return this.architectureTypes != null && !(this.architectureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> architectureTypesAsStrings() {
        return this.architectureTypes;
    }

    public final List<VirtualizationType> virtualizationTypes() {
        return VirtualizationTypeSetCopier.copyStringToEnum(this.virtualizationTypes);
    }

    public final boolean hasVirtualizationTypes() {
        return this.virtualizationTypes != null && !(this.virtualizationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> virtualizationTypesAsStrings() {
        return this.virtualizationTypes;
    }

    public final InstanceRequirementsRequest instanceRequirements() {
        return this.instanceRequirements;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectureTypes() ? this.architectureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualizationTypes() ? this.virtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceTypesFromInstanceRequirementsRequest)) {
            return false;
        }
        GetInstanceTypesFromInstanceRequirementsRequest other = (GetInstanceTypesFromInstanceRequirementsRequest)((Object)obj);
        return this.hasArchitectureTypes() == other.hasArchitectureTypes() && Objects.equals(this.architectureTypesAsStrings(), other.architectureTypesAsStrings()) && this.hasVirtualizationTypes() == other.hasVirtualizationTypes() && Objects.equals(this.virtualizationTypesAsStrings(), other.virtualizationTypesAsStrings()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstanceTypesFromInstanceRequirementsRequest").add("ArchitectureTypes", this.hasArchitectureTypes() ? this.architectureTypesAsStrings() : null).add("VirtualizationTypes", this.hasVirtualizationTypes() ? this.virtualizationTypesAsStrings() : null).add("InstanceRequirements", (Object)this.instanceRequirements()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchitectureTypes": {
                return Optional.ofNullable(clazz.cast(this.architectureTypesAsStrings()));
            }
            case "VirtualizationTypes": {
                return Optional.ofNullable(clazz.cast(this.virtualizationTypesAsStrings()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceTypesFromInstanceRequirementsRequest, T> g) {
        return obj -> g.apply((GetInstanceTypesFromInstanceRequirementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> architectureTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> virtualizationTypes = DefaultSdkAutoConstructList.getInstance();
        private InstanceRequirementsRequest instanceRequirements;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceTypesFromInstanceRequirementsRequest model) {
            super(model);
            this.architectureTypesWithStrings(model.architectureTypes);
            this.virtualizationTypesWithStrings(model.virtualizationTypes);
            this.instanceRequirements(model.instanceRequirements);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getArchitectureTypes() {
            if (this.architectureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectureTypes;
        }

        public final void setArchitectureTypes(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
        }

        @Override
        public final Builder architectureTypesWithStrings(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectureTypesWithStrings(String ... architectureTypes) {
            this.architectureTypesWithStrings(Arrays.asList(architectureTypes));
            return this;
        }

        @Override
        public final Builder architectureTypes(Collection<ArchitectureType> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copyEnumToString(architectureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectureTypes(ArchitectureType ... architectureTypes) {
            this.architectureTypes(Arrays.asList(architectureTypes));
            return this;
        }

        public final Collection<String> getVirtualizationTypes() {
            if (this.virtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.virtualizationTypes;
        }

        public final void setVirtualizationTypes(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
        }

        @Override
        public final Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualizationTypesWithStrings(String ... virtualizationTypes) {
            this.virtualizationTypesWithStrings(Arrays.asList(virtualizationTypes));
            return this;
        }

        @Override
        public final Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copyEnumToString(virtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualizationTypes(VirtualizationType ... virtualizationTypes) {
            this.virtualizationTypes(Arrays.asList(virtualizationTypes));
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceTypesFromInstanceRequirementsRequest build() {
            return new GetInstanceTypesFromInstanceRequirementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstanceTypesFromInstanceRequirementsRequest> {
        public Builder architectureTypesWithStrings(Collection<String> var1);

        public Builder architectureTypesWithStrings(String ... var1);

        public Builder architectureTypes(Collection<ArchitectureType> var1);

        public Builder architectureTypes(ArchitectureType ... var1);

        public Builder virtualizationTypesWithStrings(Collection<String> var1);

        public Builder virtualizationTypesWithStrings(String ... var1);

        public Builder virtualizationTypes(Collection<VirtualizationType> var1);

        public Builder virtualizationTypes(VirtualizationType ... var1);

        public Builder instanceRequirements(InstanceRequirementsRequest var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirementsRequest)((InstanceRequirementsRequest.Builder)InstanceRequirementsRequest.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

