/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImageIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImagesInRecycleBinRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ListImagesInRecycleBinRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageIds").getter(ListImagesInRecycleBinRequest.getter(ListImagesInRecycleBinRequest::imageIds)).setter(ListImagesInRecycleBinRequest.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build(), ListTrait.builder().memberLocationName("ImageId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImagesInRecycleBinRequest.getter(ListImagesInRecycleBinRequest::nextToken)).setter(ListImagesInRecycleBinRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListImagesInRecycleBinRequest.getter(ListImagesInRecycleBinRequest::maxResults)).setter(ListImagesInRecycleBinRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> imageIds;
    private final String nextToken;
    private final Integer maxResults;

    private ListImagesInRecycleBinRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public final List<String> imageIds() {
        return this.imageIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageIds() ? this.imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesInRecycleBinRequest)) {
            return false;
        }
        ListImagesInRecycleBinRequest other = (ListImagesInRecycleBinRequest)((Object)obj);
        return this.hasImageIds() == other.hasImageIds() && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListImagesInRecycleBinRequest").add("ImageIds", this.hasImageIds() ? this.imageIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesInRecycleBinRequest, T> g) {
        return obj -> g.apply((ListImagesInRecycleBinRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesInRecycleBinRequest model) {
            super(model);
            this.imageIds(model.imageIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            if (this.imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageIds;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListImagesInRecycleBinRequest build() {
            return new ListImagesInRecycleBinRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImagesInRecycleBinRequest> {
        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

