/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MoveByoipCidrToIpamRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, MoveByoipCidrToIpamRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(MoveByoipCidrToIpamRequest.getter(MoveByoipCidrToIpamRequest::cidr)).setter(MoveByoipCidrToIpamRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(MoveByoipCidrToIpamRequest.getter(MoveByoipCidrToIpamRequest::ipamPoolId)).setter(MoveByoipCidrToIpamRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> IPAM_POOL_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolOwner").getter(MoveByoipCidrToIpamRequest.getter(MoveByoipCidrToIpamRequest::ipamPoolOwner)).setter(MoveByoipCidrToIpamRequest.setter(Builder::ipamPoolOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolOwner").unmarshallLocationName("IpamPoolOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, IPAM_POOL_ID_FIELD, IPAM_POOL_OWNER_FIELD));
    private final String cidr;
    private final String ipamPoolId;
    private final String ipamPoolOwner;

    private MoveByoipCidrToIpamRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.ipamPoolId = builder.ipamPoolId;
        this.ipamPoolOwner = builder.ipamPoolOwner;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String ipamPoolOwner() {
        return this.ipamPoolOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveByoipCidrToIpamRequest)) {
            return false;
        }
        MoveByoipCidrToIpamRequest other = (MoveByoipCidrToIpamRequest)((Object)obj);
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.ipamPoolOwner(), other.ipamPoolOwner());
    }

    public final String toString() {
        return ToString.builder((String)"MoveByoipCidrToIpamRequest").add("Cidr", (Object)this.cidr()).add("IpamPoolId", (Object)this.ipamPoolId()).add("IpamPoolOwner", (Object)this.ipamPoolOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "IpamPoolOwner": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MoveByoipCidrToIpamRequest, T> g) {
        return obj -> g.apply((MoveByoipCidrToIpamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidr;
        private String ipamPoolId;
        private String ipamPoolOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveByoipCidrToIpamRequest model) {
            super(model);
            this.cidr(model.cidr);
            this.ipamPoolId(model.ipamPoolId);
            this.ipamPoolOwner(model.ipamPoolOwner);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getIpamPoolOwner() {
            return this.ipamPoolOwner;
        }

        public final void setIpamPoolOwner(String ipamPoolOwner) {
            this.ipamPoolOwner = ipamPoolOwner;
        }

        @Override
        public final Builder ipamPoolOwner(String ipamPoolOwner) {
            this.ipamPoolOwner = ipamPoolOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveByoipCidrToIpamRequest build() {
            return new MoveByoipCidrToIpamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MoveByoipCidrToIpamRequest> {
        public Builder cidr(String var1);

        public Builder ipamPoolId(String var1);

        public Builder ipamPoolOwner(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

