/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.HostReservation;

public class DescribeHostReservationsIterable
implements SdkIterable<DescribeHostReservationsResponse> {
    private final Ec2Client client;
    private final DescribeHostReservationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHostReservationsIterable(Ec2Client client, DescribeHostReservationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHostReservationsResponseFetcher();
    }

    public Iterator<DescribeHostReservationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HostReservation> hostReservationSet() {
        Function<DescribeHostReservationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hostReservationSet() != null) {
                return response.hostReservationSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeHostReservationsResponseFetcher
    implements SyncPageFetcher<DescribeHostReservationsResponse> {
        private DescribeHostReservationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeHostReservationsResponse nextPage(DescribeHostReservationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostReservationsIterable.this.client.describeHostReservations(DescribeHostReservationsIterable.this.firstRequest);
            }
            return DescribeHostReservationsIterable.this.client.describeHostReservations((DescribeHostReservationsRequest)((Object)DescribeHostReservationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

