/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TrafficDirection;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficMirrorFilterRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficMirrorFilterRule> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterRuleId").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::trafficMirrorFilterRuleId)).setter(TrafficMirrorFilterRule.setter(Builder::trafficMirrorFilterRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleId").unmarshallLocationName("trafficMirrorFilterRuleId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::trafficMirrorFilterId)).setter(TrafficMirrorFilterRule.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("trafficMirrorFilterId").build()}).build();
    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficDirection").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::trafficDirectionAsString)).setter(TrafficMirrorFilterRule.setter(Builder::trafficDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection").unmarshallLocationName("trafficDirection").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleNumber").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::ruleNumber)).setter(TrafficMirrorFilterRule.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("ruleNumber").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::ruleActionAsString)).setter(TrafficMirrorFilterRule.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Protocol").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::protocol)).setter(TrafficMirrorFilterRule.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<TrafficMirrorPortRange> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationPortRange").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::destinationPortRange)).setter(TrafficMirrorFilterRule.setter(Builder::destinationPortRange)).constructor(TrafficMirrorPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("destinationPortRange").build()}).build();
    private static final SdkField<TrafficMirrorPortRange> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourcePortRange").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::sourcePortRange)).setter(TrafficMirrorFilterRule.setter(Builder::sourcePortRange)).constructor(TrafficMirrorPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("sourcePortRange").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::destinationCidrBlock)).setter(TrafficMirrorFilterRule.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCidrBlock").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::sourceCidrBlock)).setter(TrafficMirrorFilterRule.setter(Builder::sourceCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock").unmarshallLocationName("sourceCidrBlock").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TrafficMirrorFilterRule.getter(TrafficMirrorFilterRule::description)).setter(TrafficMirrorFilterRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD, RULE_ACTION_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD, DESTINATION_CIDR_BLOCK_FIELD, SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trafficMirrorFilterRuleId;
    private final String trafficMirrorFilterId;
    private final String trafficDirection;
    private final Integer ruleNumber;
    private final String ruleAction;
    private final Integer protocol;
    private final TrafficMirrorPortRange destinationPortRange;
    private final TrafficMirrorPortRange sourcePortRange;
    private final String destinationCidrBlock;
    private final String sourceCidrBlock;
    private final String description;

    private TrafficMirrorFilterRule(BuilderImpl builder) {
        this.trafficMirrorFilterRuleId = builder.trafficMirrorFilterRuleId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.protocol = builder.protocol;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
    }

    public final String trafficMirrorFilterRuleId() {
        return this.trafficMirrorFilterRuleId;
    }

    public final String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public final TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(this.trafficDirection);
    }

    public final String trafficDirectionAsString() {
        return this.trafficDirection;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    public final TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final Integer protocol() {
        return this.protocol;
    }

    public final TrafficMirrorPortRange destinationPortRange() {
        return this.destinationPortRange;
    }

    public final TrafficMirrorPortRange sourcePortRange() {
        return this.sourcePortRange;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilterRule)) {
            return false;
        }
        TrafficMirrorFilterRule other = (TrafficMirrorFilterRule)obj;
        return Objects.equals(this.trafficMirrorFilterRuleId(), other.trafficMirrorFilterRuleId()) && Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.trafficDirectionAsString(), other.trafficDirectionAsString()) && Objects.equals(this.ruleNumber(), other.ruleNumber()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.sourceCidrBlock(), other.sourceCidrBlock()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficMirrorFilterRule").add("TrafficMirrorFilterRuleId", (Object)this.trafficMirrorFilterRuleId()).add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("TrafficDirection", (Object)this.trafficDirectionAsString()).add("RuleNumber", (Object)this.ruleNumber()).add("RuleAction", (Object)this.ruleActionAsString()).add("Protocol", (Object)this.protocol()).add("DestinationPortRange", (Object)this.destinationPortRange()).add("SourcePortRange", (Object)this.sourcePortRange()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("SourceCidrBlock", (Object)this.sourceCidrBlock()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterRuleId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterRuleId()));
            }
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "TrafficDirection": {
                return Optional.ofNullable(clazz.cast(this.trafficDirectionAsString()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "SourceCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.sourceCidrBlock()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorFilterRule, T> g) {
        return obj -> g.apply((TrafficMirrorFilterRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficMirrorFilterRuleId;
        private String trafficMirrorFilterId;
        private String trafficDirection;
        private Integer ruleNumber;
        private String ruleAction;
        private Integer protocol;
        private TrafficMirrorPortRange destinationPortRange;
        private TrafficMirrorPortRange sourcePortRange;
        private String destinationCidrBlock;
        private String sourceCidrBlock;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorFilterRule model) {
            this.trafficMirrorFilterRuleId(model.trafficMirrorFilterRuleId);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.trafficDirection(model.trafficDirection);
            this.ruleNumber(model.ruleNumber);
            this.ruleAction(model.ruleAction);
            this.protocol(model.protocol);
            this.destinationPortRange(model.destinationPortRange);
            this.sourcePortRange(model.sourcePortRange);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.sourceCidrBlock(model.sourceCidrBlock);
            this.description(model.description);
        }

        public final String getTrafficMirrorFilterRuleId() {
            return this.trafficMirrorFilterRuleId;
        }

        public final void setTrafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
        }

        @Override
        @Transient
        public final Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        @Transient
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final String getTrafficDirection() {
            return this.trafficDirection;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        @Override
        @Transient
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        @Transient
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        @Transient
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        @Transient
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        @Transient
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final Integer getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final TrafficMirrorPortRange.Builder getDestinationPortRange() {
            return this.destinationPortRange != null ? this.destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRange.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationPortRange(TrafficMirrorPortRange destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final TrafficMirrorPortRange.Builder getSourcePortRange() {
            return this.sourcePortRange != null ? this.sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(TrafficMirrorPortRange.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        @Transient
        public final Builder sourcePortRange(TrafficMirrorPortRange sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        @Transient
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public TrafficMirrorFilterRule build() {
            return new TrafficMirrorFilterRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficMirrorFilterRule> {
        public Builder trafficMirrorFilterRuleId(String var1);

        public Builder trafficMirrorFilterId(String var1);

        public Builder trafficDirection(String var1);

        public Builder trafficDirection(TrafficDirection var1);

        public Builder ruleNumber(Integer var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(TrafficMirrorRuleAction var1);

        public Builder protocol(Integer var1);

        public Builder destinationPortRange(TrafficMirrorPortRange var1);

        default public Builder destinationPortRange(Consumer<TrafficMirrorPortRange.Builder> destinationPortRange) {
            return this.destinationPortRange((TrafficMirrorPortRange)((TrafficMirrorPortRange.Builder)TrafficMirrorPortRange.builder().applyMutation(destinationPortRange)).build());
        }

        public Builder sourcePortRange(TrafficMirrorPortRange var1);

        default public Builder sourcePortRange(Consumer<TrafficMirrorPortRange.Builder> sourcePortRange) {
            return this.sourcePortRange((TrafficMirrorPortRange)((TrafficMirrorPortRange.Builder)TrafficMirrorPortRange.builder().applyMutation(sourcePortRange)).build());
        }

        public Builder destinationCidrBlock(String var1);

        public Builder sourceCidrBlock(String var1);

        public Builder description(String var1);
    }
}

