/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReleaseAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReleaseAddressRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(ReleaseAddressRequest.getter(ReleaseAddressRequest::allocationId)).setter(ReleaseAddressRequest.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(ReleaseAddressRequest.getter(ReleaseAddressRequest::publicIp)).setter(ReleaseAddressRequest.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("PublicIp").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(ReleaseAddressRequest.getter(ReleaseAddressRequest::networkBorderGroup)).setter(ReleaseAddressRequest.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("NetworkBorderGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, PUBLIC_IP_FIELD, NETWORK_BORDER_GROUP_FIELD));
    private final String allocationId;
    private final String publicIp;
    private final String networkBorderGroup;

    private ReleaseAddressRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.publicIp = builder.publicIp;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseAddressRequest)) {
            return false;
        }
        ReleaseAddressRequest other = (ReleaseAddressRequest)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ReleaseAddressRequest").add("AllocationId", (Object)this.allocationId()).add("PublicIp", (Object)this.publicIp()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReleaseAddressRequest, T> g) {
        return obj -> g.apply((ReleaseAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String allocationId;
        private String publicIp;
        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseAddressRequest model) {
            super(model);
            this.allocationId(model.allocationId);
            this.publicIp(model.publicIp);
            this.networkBorderGroup(model.networkBorderGroup);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        @Transient
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        @Transient
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        @Transient
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReleaseAddressRequest build() {
            return new ReleaseAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReleaseAddressRequest> {
        public Builder allocationId(String var1);

        public Builder publicIp(String var1);

        public Builder networkBorderGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

