/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationStateSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult;
import software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResultSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelCapacityReservationFleetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CancelCapacityReservationFleetsResponse> {
    private static final SdkField<List<CapacityReservationFleetCancellationState>> SUCCESSFUL_FLEET_CANCELLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulFleetCancellations").getter(CancelCapacityReservationFleetsResponse.getter(CancelCapacityReservationFleetsResponse::successfulFleetCancellations)).setter(CancelCapacityReservationFleetsResponse.setter(Builder::successfulFleetCancellations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetCancellationSet").unmarshallLocationName("successfulFleetCancellationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationFleetCancellationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<FailedCapacityReservationFleetCancellationResult>> FAILED_FLEET_CANCELLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedFleetCancellations").getter(CancelCapacityReservationFleetsResponse.getter(CancelCapacityReservationFleetsResponse::failedFleetCancellations)).setter(CancelCapacityReservationFleetsResponse.setter(Builder::failedFleetCancellations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedFleetCancellationSet").unmarshallLocationName("failedFleetCancellationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCapacityReservationFleetCancellationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FLEET_CANCELLATIONS_FIELD, FAILED_FLEET_CANCELLATIONS_FIELD));
    private final List<CapacityReservationFleetCancellationState> successfulFleetCancellations;
    private final List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations;

    private CancelCapacityReservationFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetCancellations = builder.successfulFleetCancellations;
        this.failedFleetCancellations = builder.failedFleetCancellations;
    }

    public final boolean hasSuccessfulFleetCancellations() {
        return this.successfulFleetCancellations != null && !(this.successfulFleetCancellations instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationFleetCancellationState> successfulFleetCancellations() {
        return this.successfulFleetCancellations;
    }

    public final boolean hasFailedFleetCancellations() {
        return this.failedFleetCancellations != null && !(this.failedFleetCancellations instanceof SdkAutoConstructList);
    }

    public final List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations() {
        return this.failedFleetCancellations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulFleetCancellations() ? this.successfulFleetCancellations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedFleetCancellations() ? this.failedFleetCancellations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelCapacityReservationFleetsResponse)) {
            return false;
        }
        CancelCapacityReservationFleetsResponse other = (CancelCapacityReservationFleetsResponse)((Object)obj);
        return this.hasSuccessfulFleetCancellations() == other.hasSuccessfulFleetCancellations() && Objects.equals(this.successfulFleetCancellations(), other.successfulFleetCancellations()) && this.hasFailedFleetCancellations() == other.hasFailedFleetCancellations() && Objects.equals(this.failedFleetCancellations(), other.failedFleetCancellations());
    }

    public final String toString() {
        return ToString.builder((String)"CancelCapacityReservationFleetsResponse").add("SuccessfulFleetCancellations", this.hasSuccessfulFleetCancellations() ? this.successfulFleetCancellations() : null).add("FailedFleetCancellations", this.hasFailedFleetCancellations() ? this.failedFleetCancellations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulFleetCancellations": {
                return Optional.ofNullable(clazz.cast(this.successfulFleetCancellations()));
            }
            case "FailedFleetCancellations": {
                return Optional.ofNullable(clazz.cast(this.failedFleetCancellations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelCapacityReservationFleetsResponse, T> g) {
        return obj -> g.apply((CancelCapacityReservationFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityReservationFleetCancellationState> successfulFleetCancellations = DefaultSdkAutoConstructList.getInstance();
        private List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelCapacityReservationFleetsResponse model) {
            super(model);
            this.successfulFleetCancellations(model.successfulFleetCancellations);
            this.failedFleetCancellations(model.failedFleetCancellations);
        }

        public final List<CapacityReservationFleetCancellationState.Builder> getSuccessfulFleetCancellations() {
            List<CapacityReservationFleetCancellationState.Builder> result = CapacityReservationFleetCancellationStateSetCopier.copyToBuilder(this.successfulFleetCancellations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulFleetCancellations(Collection<CapacityReservationFleetCancellationState.BuilderImpl> successfulFleetCancellations) {
            this.successfulFleetCancellations = CapacityReservationFleetCancellationStateSetCopier.copyFromBuilder(successfulFleetCancellations);
        }

        @Override
        @Transient
        public final Builder successfulFleetCancellations(Collection<CapacityReservationFleetCancellationState> successfulFleetCancellations) {
            this.successfulFleetCancellations = CapacityReservationFleetCancellationStateSetCopier.copy(successfulFleetCancellations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successfulFleetCancellations(CapacityReservationFleetCancellationState ... successfulFleetCancellations) {
            this.successfulFleetCancellations(Arrays.asList(successfulFleetCancellations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successfulFleetCancellations(Consumer<CapacityReservationFleetCancellationState.Builder> ... successfulFleetCancellations) {
            this.successfulFleetCancellations(Stream.of(successfulFleetCancellations).map(c -> (CapacityReservationFleetCancellationState)((CapacityReservationFleetCancellationState.Builder)CapacityReservationFleetCancellationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedCapacityReservationFleetCancellationResult.Builder> getFailedFleetCancellations() {
            List<FailedCapacityReservationFleetCancellationResult.Builder> result = FailedCapacityReservationFleetCancellationResultSetCopier.copyToBuilder(this.failedFleetCancellations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedFleetCancellations(Collection<FailedCapacityReservationFleetCancellationResult.BuilderImpl> failedFleetCancellations) {
            this.failedFleetCancellations = FailedCapacityReservationFleetCancellationResultSetCopier.copyFromBuilder(failedFleetCancellations);
        }

        @Override
        @Transient
        public final Builder failedFleetCancellations(Collection<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations) {
            this.failedFleetCancellations = FailedCapacityReservationFleetCancellationResultSetCopier.copy(failedFleetCancellations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedFleetCancellations(FailedCapacityReservationFleetCancellationResult ... failedFleetCancellations) {
            this.failedFleetCancellations(Arrays.asList(failedFleetCancellations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedFleetCancellations(Consumer<FailedCapacityReservationFleetCancellationResult.Builder> ... failedFleetCancellations) {
            this.failedFleetCancellations(Stream.of(failedFleetCancellations).map(c -> (FailedCapacityReservationFleetCancellationResult)((FailedCapacityReservationFleetCancellationResult.Builder)FailedCapacityReservationFleetCancellationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CancelCapacityReservationFleetsResponse build() {
            return new CancelCapacityReservationFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelCapacityReservationFleetsResponse> {
        public Builder successfulFleetCancellations(Collection<CapacityReservationFleetCancellationState> var1);

        public Builder successfulFleetCancellations(CapacityReservationFleetCancellationState ... var1);

        public Builder successfulFleetCancellations(Consumer<CapacityReservationFleetCancellationState.Builder> ... var1);

        public Builder failedFleetCancellations(Collection<FailedCapacityReservationFleetCancellationResult> var1);

        public Builder failedFleetCancellations(FailedCapacityReservationFleetCancellationResult ... var1);

        public Builder failedFleetCancellations(Consumer<FailedCapacityReservationFleetCancellationResult.Builder> ... var1);
    }
}

