/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocation;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamPoolAllocationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamPoolAllocationsResponse> {
    private static final SdkField<List<IpamPoolAllocation>> IPAM_POOL_ALLOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPoolAllocations").getter(GetIpamPoolAllocationsResponse.getter(GetIpamPoolAllocationsResponse::ipamPoolAllocations)).setter(GetIpamPoolAllocationsResponse.setter(Builder::ipamPoolAllocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolAllocationSet").unmarshallLocationName("ipamPoolAllocationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPoolAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamPoolAllocationsResponse.getter(GetIpamPoolAllocationsResponse::nextToken)).setter(GetIpamPoolAllocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ALLOCATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IpamPoolAllocation> ipamPoolAllocations;
    private final String nextToken;

    private GetIpamPoolAllocationsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPoolAllocations = builder.ipamPoolAllocations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamPoolAllocations() {
        return this.ipamPoolAllocations != null && !(this.ipamPoolAllocations instanceof SdkAutoConstructList);
    }

    public final List<IpamPoolAllocation> ipamPoolAllocations() {
        return this.ipamPoolAllocations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPoolAllocations() ? this.ipamPoolAllocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPoolAllocationsResponse)) {
            return false;
        }
        GetIpamPoolAllocationsResponse other = (GetIpamPoolAllocationsResponse)((Object)obj);
        return this.hasIpamPoolAllocations() == other.hasIpamPoolAllocations() && Objects.equals(this.ipamPoolAllocations(), other.ipamPoolAllocations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamPoolAllocationsResponse").add("IpamPoolAllocations", this.hasIpamPoolAllocations() ? this.ipamPoolAllocations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPoolAllocations": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolAllocations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPoolAllocationsResponse, T> g) {
        return obj -> g.apply((GetIpamPoolAllocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamPoolAllocation> ipamPoolAllocations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPoolAllocationsResponse model) {
            super(model);
            this.ipamPoolAllocations(model.ipamPoolAllocations);
            this.nextToken(model.nextToken);
        }

        public final List<IpamPoolAllocation.Builder> getIpamPoolAllocations() {
            List<IpamPoolAllocation.Builder> result = IpamPoolAllocationSetCopier.copyToBuilder(this.ipamPoolAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPoolAllocations(Collection<IpamPoolAllocation.BuilderImpl> ipamPoolAllocations) {
            this.ipamPoolAllocations = IpamPoolAllocationSetCopier.copyFromBuilder(ipamPoolAllocations);
        }

        @Override
        @Transient
        public final Builder ipamPoolAllocations(Collection<IpamPoolAllocation> ipamPoolAllocations) {
            this.ipamPoolAllocations = IpamPoolAllocationSetCopier.copy(ipamPoolAllocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipamPoolAllocations(IpamPoolAllocation ... ipamPoolAllocations) {
            this.ipamPoolAllocations(Arrays.asList(ipamPoolAllocations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipamPoolAllocations(Consumer<IpamPoolAllocation.Builder> ... ipamPoolAllocations) {
            this.ipamPoolAllocations(Stream.of(ipamPoolAllocations).map(c -> (IpamPoolAllocation)((IpamPoolAllocation.Builder)IpamPoolAllocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPoolAllocationsResponse build() {
            return new GetIpamPoolAllocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamPoolAllocationsResponse> {
        public Builder ipamPoolAllocations(Collection<IpamPoolAllocation> var1);

        public Builder ipamPoolAllocations(IpamPoolAllocation ... var1);

        public Builder ipamPoolAllocations(Consumer<IpamPoolAllocation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

