/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Purchase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Purchase> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(Purchase.getter(Purchase::currencyCodeAsString)).setter(Purchase.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Purchase.getter(Purchase::duration)).setter(Purchase.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").unmarshallLocationName("duration").build()}).build();
    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIdSet").getter(Purchase.getter(Purchase::hostIdSet)).setter(Purchase.setter(Builder::hostIdSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet").unmarshallLocationName("hostIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostReservationId").getter(Purchase.getter(Purchase::hostReservationId)).setter(Purchase.setter(Builder::hostReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId").unmarshallLocationName("hostReservationId").build()}).build();
    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyPrice").getter(Purchase.getter(Purchase::hourlyPrice)).setter(Purchase.setter(Builder::hourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice").unmarshallLocationName("hourlyPrice").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(Purchase.getter(Purchase::instanceFamily)).setter(Purchase.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("instanceFamily").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(Purchase.getter(Purchase::paymentOptionAsString)).setter(Purchase.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").unmarshallLocationName("paymentOption").build()}).build();
    private static final SdkField<String> UPFRONT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontPrice").getter(Purchase.getter(Purchase::upfrontPrice)).setter(Purchase.setter(Builder::upfrontPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice").unmarshallLocationName("upfrontPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, DURATION_FIELD, HOST_ID_SET_FIELD, HOST_RESERVATION_ID_FIELD, HOURLY_PRICE_FIELD, INSTANCE_FAMILY_FIELD, PAYMENT_OPTION_FIELD, UPFRONT_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final Integer duration;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String paymentOption;
    private final String upfrontPrice;

    private Purchase(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final boolean hasHostIdSet() {
        return this.hostIdSet != null && !(this.hostIdSet instanceof SdkAutoConstructList);
    }

    public final List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public final String hostReservationId() {
        return this.hostReservationId;
    }

    public final String hourlyPrice() {
        return this.hourlyPrice;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIdSet() ? this.hostIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Purchase)) {
            return false;
        }
        Purchase other = (Purchase)obj;
        return Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.duration(), other.duration()) && this.hasHostIdSet() == other.hasHostIdSet() && Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.hostReservationId(), other.hostReservationId()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.upfrontPrice(), other.upfrontPrice());
    }

    public final String toString() {
        return ToString.builder((String)"Purchase").add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Duration", (Object)this.duration()).add("HostIdSet", this.hasHostIdSet() ? this.hostIdSet() : null).add("HostReservationId", (Object)this.hostReservationId()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceFamily", (Object)this.instanceFamily()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("UpfrontPrice", (Object)this.upfrontPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "HostIdSet": {
                return Optional.ofNullable(clazz.cast(this.hostIdSet()));
            }
            case "HostReservationId": {
                return Optional.ofNullable(clazz.cast(this.hostReservationId()));
            }
            case "HourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "UpfrontPrice": {
                return Optional.ofNullable(clazz.cast(this.upfrontPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Purchase, T> g) {
        return obj -> g.apply((Purchase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String paymentOption;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Purchase model) {
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.hostIdSet(model.hostIdSet);
            this.hostReservationId(model.hostReservationId);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceFamily(model.instanceFamily);
            this.paymentOption(model.paymentOption);
            this.upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        @Transient
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Collection<String> getHostIdSet() {
            if (this.hostIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIdSet;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        @Override
        @Transient
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        @Override
        @Transient
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        @Override
        @Transient
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        @Transient
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        @Transient
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public Purchase build() {
            return new Purchase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Purchase> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder upfrontPrice(String var1);
    }
}

