/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceRequirements;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring;
import software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotFleetLaunchSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotFleetLaunchSpecification> {
    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::securityGroups)).setter(SpotFleetLaunchSpecification.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> ADDRESSING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressingType").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::addressingType)).setter(SpotFleetLaunchSpecification.setter(Builder::addressingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressingType").unmarshallLocationName("addressingType").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::blockDeviceMappings)).setter(SpotFleetLaunchSpecification.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::ebsOptimized)).setter(SpotFleetLaunchSpecification.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::iamInstanceProfile)).setter(SpotFleetLaunchSpecification.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfileSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::imageId)).setter(SpotFleetLaunchSpecification.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::instanceTypeAsString)).setter(SpotFleetLaunchSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::kernelId)).setter(SpotFleetLaunchSpecification.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::keyName)).setter(SpotFleetLaunchSpecification.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<SpotFleetMonitoring> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::monitoring)).setter(SpotFleetLaunchSpecification.setter(Builder::monitoring)).constructor(SpotFleetMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("monitoring").build()}).build();
    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::networkInterfaces)).setter(SpotFleetLaunchSpecification.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet").unmarshallLocationName("networkInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceNetworkInterfaceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<SpotPlacement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::placement)).setter(SpotFleetLaunchSpecification.setter(Builder::placement)).constructor(SpotPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::ramdiskId)).setter(SpotFleetLaunchSpecification.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("ramdiskId").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::spotPrice)).setter(SpotFleetLaunchSpecification.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").unmarshallLocationName("spotPrice").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::subnetId)).setter(SpotFleetLaunchSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::userData)).setter(SpotFleetLaunchSpecification.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WeightedCapacity").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::weightedCapacity)).setter(SpotFleetLaunchSpecification.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").unmarshallLocationName("weightedCapacity").build()}).build();
    private static final SdkField<List<SpotFleetTagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::tagSpecifications)).setter(SpotFleetLaunchSpecification.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecificationSet").unmarshallLocationName("tagSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotFleetTagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(SpotFleetLaunchSpecification.getter(SpotFleetLaunchSpecification::instanceRequirements)).setter(SpotFleetLaunchSpecification.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("instanceRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUPS_FIELD, ADDRESSING_TYPE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SPOT_PRICE_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD, WEIGHTED_CAPACITY_FIELD, TAG_SPECIFICATIONS_FIELD, INSTANCE_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GroupIdentifier> securityGroups;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final SpotFleetMonitoring monitoring;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String spotPrice;
    private final String subnetId;
    private final String userData;
    private final Double weightedCapacity;
    private final List<SpotFleetTagSpecification> tagSpecifications;
    private final InstanceRequirements instanceRequirements;

    private SpotFleetLaunchSpecification(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.spotPrice = builder.spotPrice;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.weightedCapacity = builder.weightedCapacity;
        this.tagSpecifications = builder.tagSpecifications;
        this.instanceRequirements = builder.instanceRequirements;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public final String addressingType() {
        return this.addressingType;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final SpotFleetMonitoring monitoring() {
        return this.monitoring;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final SpotPlacement placement() {
        return this.placement;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String userData() {
        return this.userData;
    }

    public final Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<SpotFleetTagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification)obj;
        return this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.addressingType(), other.addressingType()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"SpotFleetLaunchSpecification").add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("AddressingType", (Object)this.addressingType()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SpotPrice", (Object)this.spotPrice()).add("SubnetId", (Object)this.subnetId()).add("UserData", (Object)this.userData()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("InstanceRequirements", (Object)this.instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "AddressingType": {
                return Optional.ofNullable(clazz.cast(this.addressingType()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetLaunchSpecification, T> g) {
        return obj -> g.apply((SpotFleetLaunchSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private SpotFleetMonitoring monitoring;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private SpotPlacement placement;
        private String ramdiskId;
        private String spotPrice;
        private String subnetId;
        private String userData;
        private Double weightedCapacity;
        private List<SpotFleetTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private InstanceRequirements instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetLaunchSpecification model) {
            this.securityGroups(model.securityGroups);
            this.addressingType(model.addressingType);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.spotPrice(model.spotPrice);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
            this.weightedCapacity(model.weightedCapacity);
            this.tagSpecifications(model.tagSpecifications);
            this.instanceRequirements(model.instanceRequirements);
        }

        public final List<GroupIdentifier.Builder> getSecurityGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        @Override
        @Transient
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        @Transient
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        @Transient
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        @Transient
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        @Transient
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final SpotFleetMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(SpotFleetMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = InstanceNetworkInterfaceSpecificationListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        @Transient
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SpotPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        @Transient
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        @Transient
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        @Transient
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        @Transient
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        @Transient
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final List<SpotFleetTagSpecification.Builder> getTagSpecifications() {
            List<SpotFleetTagSpecification.Builder> result = SpotFleetTagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<SpotFleetTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(SpotFleetTagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (SpotFleetTagSpecification)((SpotFleetTagSpecification.Builder)SpotFleetTagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public SpotFleetLaunchSpecification build() {
            return new SpotFleetLaunchSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotFleetLaunchSpecification> {
        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder securityGroups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder monitoring(SpotFleetMonitoring var1);

        default public Builder monitoring(Consumer<SpotFleetMonitoring.Builder> monitoring) {
            return this.monitoring((SpotFleetMonitoring)((SpotFleetMonitoring.Builder)SpotFleetMonitoring.builder().applyMutation(monitoring)).build());
        }

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder placement(SpotPlacement var1);

        default public Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return this.placement((SpotPlacement)((SpotPlacement.Builder)SpotPlacement.builder().applyMutation(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder spotPrice(String var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder tagSpecifications(Collection<SpotFleetTagSpecification> var1);

        public Builder tagSpecifications(SpotFleetTagSpecification ... var1);

        public Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder> ... var1);

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }
    }
}

