/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotPrice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotPrice> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SpotPrice.getter(SpotPrice::availabilityZone)).setter(SpotPrice.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(SpotPrice.getter(SpotPrice::instanceTypeAsString)).setter(SpotPrice.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(SpotPrice.getter(SpotPrice::productDescriptionAsString)).setter(SpotPrice.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("productDescription").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(SpotPrice.getter(SpotPrice::spotPrice)).setter(SpotPrice.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").unmarshallLocationName("spotPrice").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(SpotPrice.getter(SpotPrice::timestamp)).setter(SpotPrice.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD, PRODUCT_DESCRIPTION_FIELD, SPOT_PRICE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String instanceType;
    private final String productDescription;
    private final String spotPrice;
    private final Instant timestamp;

    private SpotPrice(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.spotPrice = builder.spotPrice;
        this.timestamp = builder.timestamp;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public final String productDescriptionAsString() {
        return this.productDescription;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPrice)) {
            return false;
        }
        SpotPrice other = (SpotPrice)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"SpotPrice").add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("SpotPrice", (Object)this.spotPrice()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescriptionAsString()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotPrice, T> g) {
        return obj -> g.apply((SpotPrice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String instanceType;
        private String productDescription;
        private String spotPrice;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPrice model) {
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
            this.productDescription(model.productDescription);
            this.spotPrice(model.spotPrice);
            this.timestamp(model.timestamp);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        @Transient
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        @Transient
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        @Transient
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SpotPrice build() {
            return new SpotPrice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotPrice> {
        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder spotPrice(String var1);

        public Builder timestamp(Instant var1);
    }
}

