/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationStrategy;
import software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior;
import software.amazon.awssdk.services.ec2.model.LaunchSpecsListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateConfigListCopier;
import software.amazon.awssdk.services.ec2.model.LoadBalancersConfig;
import software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotFleetRequestConfigData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotFleetRequestConfigData> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::allocationStrategyAsString)).setter(SpotFleetRequestConfigData.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("allocationStrategy").build()}).build();
    private static final SdkField<String> ON_DEMAND_ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnDemandAllocationStrategy").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::onDemandAllocationStrategyAsString)).setter(SpotFleetRequestConfigData.setter(Builder::onDemandAllocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandAllocationStrategy").unmarshallLocationName("onDemandAllocationStrategy").build()}).build();
    private static final SdkField<SpotMaintenanceStrategies> SPOT_MAINTENANCE_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotMaintenanceStrategies").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::spotMaintenanceStrategies)).setter(SpotFleetRequestConfigData.setter(Builder::spotMaintenanceStrategies)).constructor(SpotMaintenanceStrategies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaintenanceStrategies").unmarshallLocationName("spotMaintenanceStrategies").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::clientToken)).setter(SpotFleetRequestConfigData.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExcessCapacityTerminationPolicy").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::excessCapacityTerminationPolicyAsString)).setter(SpotFleetRequestConfigData.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("excessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FulfilledCapacity").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::fulfilledCapacity)).setter(SpotFleetRequestConfigData.setter(Builder::fulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity").unmarshallLocationName("fulfilledCapacity").build()}).build();
    private static final SdkField<Double> ON_DEMAND_FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("OnDemandFulfilledCapacity").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::onDemandFulfilledCapacity)).setter(SpotFleetRequestConfigData.setter(Builder::onDemandFulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandFulfilledCapacity").unmarshallLocationName("onDemandFulfilledCapacity").build()}).build();
    private static final SdkField<String> IAM_FLEET_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamFleetRole").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::iamFleetRole)).setter(SpotFleetRequestConfigData.setter(Builder::iamFleetRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamFleetRole").unmarshallLocationName("iamFleetRole").build()}).build();
    private static final SdkField<List<SpotFleetLaunchSpecification>> LAUNCH_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchSpecifications").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::launchSpecifications)).setter(SpotFleetRequestConfigData.setter(Builder::launchSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecifications").unmarshallLocationName("launchSpecifications").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotFleetLaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplateConfigs").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::launchTemplateConfigs)).setter(SpotFleetRequestConfigData.setter(Builder::launchTemplateConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs").unmarshallLocationName("launchTemplateConfigs").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::spotPrice)).setter(SpotFleetRequestConfigData.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").unmarshallLocationName("spotPrice").build()}).build();
    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCapacity").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::targetCapacity)).setter(SpotFleetRequestConfigData.setter(Builder::targetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity").unmarshallLocationName("targetCapacity").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OnDemandTargetCapacity").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::onDemandTargetCapacity)).setter(SpotFleetRequestConfigData.setter(Builder::onDemandTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity").unmarshallLocationName("onDemandTargetCapacity").build()}).build();
    private static final SdkField<String> ON_DEMAND_MAX_TOTAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnDemandMaxTotalPrice").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::onDemandMaxTotalPrice)).setter(SpotFleetRequestConfigData.setter(Builder::onDemandMaxTotalPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandMaxTotalPrice").unmarshallLocationName("onDemandMaxTotalPrice").build()}).build();
    private static final SdkField<String> SPOT_MAX_TOTAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotMaxTotalPrice").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::spotMaxTotalPrice)).setter(SpotFleetRequestConfigData.setter(Builder::spotMaxTotalPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxTotalPrice").unmarshallLocationName("spotMaxTotalPrice").build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminateInstancesWithExpiration").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::terminateInstancesWithExpiration)).setter(SpotFleetRequestConfigData.setter(Builder::terminateInstancesWithExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration").unmarshallLocationName("terminateInstancesWithExpiration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::typeAsString)).setter(SpotFleetRequestConfigData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFrom").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::validFrom)).setter(SpotFleetRequestConfigData.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").unmarshallLocationName("validFrom").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::validUntil)).setter(SpotFleetRequestConfigData.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("validUntil").build()}).build();
    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplaceUnhealthyInstances").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::replaceUnhealthyInstances)).setter(SpotFleetRequestConfigData.setter(Builder::replaceUnhealthyInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances").unmarshallLocationName("replaceUnhealthyInstances").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInterruptionBehavior").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::instanceInterruptionBehaviorAsString)).setter(SpotFleetRequestConfigData.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("instanceInterruptionBehavior").build()}).build();
    private static final SdkField<LoadBalancersConfig> LOAD_BALANCERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancersConfig").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::loadBalancersConfig)).setter(SpotFleetRequestConfigData.setter(Builder::loadBalancersConfig)).constructor(LoadBalancersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancersConfig").unmarshallLocationName("loadBalancersConfig").build()}).build();
    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancePoolsToUseCount").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::instancePoolsToUseCount)).setter(SpotFleetRequestConfigData.setter(Builder::instancePoolsToUseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount").unmarshallLocationName("instancePoolsToUseCount").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::context)).setter(SpotFleetRequestConfigData.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").unmarshallLocationName("context").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(SpotFleetRequestConfigData.getter(SpotFleetRequestConfigData::tagSpecifications)).setter(SpotFleetRequestConfigData.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, ON_DEMAND_ALLOCATION_STRATEGY_FIELD, SPOT_MAINTENANCE_STRATEGIES_FIELD, CLIENT_TOKEN_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, FULFILLED_CAPACITY_FIELD, ON_DEMAND_FULFILLED_CAPACITY_FIELD, IAM_FLEET_ROLE_FIELD, LAUNCH_SPECIFICATIONS_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, SPOT_PRICE_FIELD, TARGET_CAPACITY_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD, ON_DEMAND_MAX_TOTAL_PRICE_FIELD, SPOT_MAX_TOTAL_PRICE_FIELD, TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD, REPLACE_UNHEALTHY_INSTANCES_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, LOAD_BALANCERS_CONFIG_FIELD, INSTANCE_POOLS_TO_USE_COUNT_FIELD, CONTEXT_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final String onDemandAllocationStrategy;
    private final SpotMaintenanceStrategies spotMaintenanceStrategies;
    private final String clientToken;
    private final String excessCapacityTerminationPolicy;
    private final Double fulfilledCapacity;
    private final Double onDemandFulfilledCapacity;
    private final String iamFleetRole;
    private final List<SpotFleetLaunchSpecification> launchSpecifications;
    private final List<LaunchTemplateConfig> launchTemplateConfigs;
    private final String spotPrice;
    private final Integer targetCapacity;
    private final Integer onDemandTargetCapacity;
    private final String onDemandMaxTotalPrice;
    private final String spotMaxTotalPrice;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;
    private final String instanceInterruptionBehavior;
    private final LoadBalancersConfig loadBalancersConfig;
    private final Integer instancePoolsToUseCount;
    private final String context;
    private final List<TagSpecification> tagSpecifications;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
        this.spotMaintenanceStrategies = builder.spotMaintenanceStrategies;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.onDemandFulfilledCapacity = builder.onDemandFulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.onDemandMaxTotalPrice = builder.onDemandMaxTotalPrice;
        this.spotMaxTotalPrice = builder.spotMaxTotalPrice;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.loadBalancersConfig = builder.loadBalancersConfig;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
        this.context = builder.context;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final OnDemandAllocationStrategy onDemandAllocationStrategy() {
        return OnDemandAllocationStrategy.fromValue(this.onDemandAllocationStrategy);
    }

    public final String onDemandAllocationStrategyAsString() {
        return this.onDemandAllocationStrategy;
    }

    public final SpotMaintenanceStrategies spotMaintenanceStrategies() {
        return this.spotMaintenanceStrategies;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public final String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public final Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public final Double onDemandFulfilledCapacity() {
        return this.onDemandFulfilledCapacity;
    }

    public final String iamFleetRole() {
        return this.iamFleetRole;
    }

    public final boolean hasLaunchSpecifications() {
        return this.launchSpecifications != null && !(this.launchSpecifications instanceof SdkAutoConstructList);
    }

    public final List<SpotFleetLaunchSpecification> launchSpecifications() {
        return this.launchSpecifications;
    }

    public final boolean hasLaunchTemplateConfigs() {
        return this.launchTemplateConfigs != null && !(this.launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateConfig> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final Integer targetCapacity() {
        return this.targetCapacity;
    }

    public final Integer onDemandTargetCapacity() {
        return this.onDemandTargetCapacity;
    }

    public final String onDemandMaxTotalPrice() {
        return this.onDemandMaxTotalPrice;
    }

    public final String spotMaxTotalPrice() {
        return this.spotMaxTotalPrice;
    }

    public final Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public final FleetType type() {
        return FleetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant validFrom() {
        return this.validFrom;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public final Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public final InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public final String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public final LoadBalancersConfig loadBalancersConfig() {
        return this.loadBalancersConfig;
    }

    public final Integer instancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public final String context() {
        return this.context;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandAllocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotMaintenanceStrategies());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandFulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamFleetRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchSpecifications() ? this.launchSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandMaxTotalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotMaxTotalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePoolsToUseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.onDemandAllocationStrategyAsString(), other.onDemandAllocationStrategyAsString()) && Objects.equals(this.spotMaintenanceStrategies(), other.spotMaintenanceStrategies()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && Objects.equals(this.fulfilledCapacity(), other.fulfilledCapacity()) && Objects.equals(this.onDemandFulfilledCapacity(), other.onDemandFulfilledCapacity()) && Objects.equals(this.iamFleetRole(), other.iamFleetRole()) && this.hasLaunchSpecifications() == other.hasLaunchSpecifications() && Objects.equals(this.launchSpecifications(), other.launchSpecifications()) && this.hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs() && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.targetCapacity(), other.targetCapacity()) && Objects.equals(this.onDemandTargetCapacity(), other.onDemandTargetCapacity()) && Objects.equals(this.onDemandMaxTotalPrice(), other.onDemandMaxTotalPrice()) && Objects.equals(this.spotMaxTotalPrice(), other.spotMaxTotalPrice()) && Objects.equals(this.terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.replaceUnhealthyInstances(), other.replaceUnhealthyInstances()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.loadBalancersConfig(), other.loadBalancersConfig()) && Objects.equals(this.instancePoolsToUseCount(), other.instancePoolsToUseCount()) && Objects.equals(this.context(), other.context()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"SpotFleetRequestConfigData").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("OnDemandAllocationStrategy", (Object)this.onDemandAllocationStrategyAsString()).add("SpotMaintenanceStrategies", (Object)this.spotMaintenanceStrategies()).add("ClientToken", (Object)this.clientToken()).add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("FulfilledCapacity", (Object)this.fulfilledCapacity()).add("OnDemandFulfilledCapacity", (Object)this.onDemandFulfilledCapacity()).add("IamFleetRole", (Object)this.iamFleetRole()).add("LaunchSpecifications", this.hasLaunchSpecifications() ? this.launchSpecifications() : null).add("LaunchTemplateConfigs", this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null).add("SpotPrice", (Object)this.spotPrice()).add("TargetCapacity", (Object)this.targetCapacity()).add("OnDemandTargetCapacity", (Object)this.onDemandTargetCapacity()).add("OnDemandMaxTotalPrice", (Object)this.onDemandMaxTotalPrice()).add("SpotMaxTotalPrice", (Object)this.spotMaxTotalPrice()).add("TerminateInstancesWithExpiration", (Object)this.terminateInstancesWithExpiration()).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("ReplaceUnhealthyInstances", (Object)this.replaceUnhealthyInstances()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("LoadBalancersConfig", (Object)this.loadBalancersConfig()).add("InstancePoolsToUseCount", (Object)this.instancePoolsToUseCount()).add("Context", (Object)this.context()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "OnDemandAllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.onDemandAllocationStrategyAsString()));
            }
            case "SpotMaintenanceStrategies": {
                return Optional.ofNullable(clazz.cast(this.spotMaintenanceStrategies()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "FulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledCapacity()));
            }
            case "OnDemandFulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandFulfilledCapacity()));
            }
            case "IamFleetRole": {
                return Optional.ofNullable(clazz.cast(this.iamFleetRole()));
            }
            case "LaunchSpecifications": {
                return Optional.ofNullable(clazz.cast(this.launchSpecifications()));
            }
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "TargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetCapacity()));
            }
            case "OnDemandTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandTargetCapacity()));
            }
            case "OnDemandMaxTotalPrice": {
                return Optional.ofNullable(clazz.cast(this.onDemandMaxTotalPrice()));
            }
            case "SpotMaxTotalPrice": {
                return Optional.ofNullable(clazz.cast(this.spotMaxTotalPrice()));
            }
            case "TerminateInstancesWithExpiration": {
                return Optional.ofNullable(clazz.cast(this.terminateInstancesWithExpiration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "ReplaceUnhealthyInstances": {
                return Optional.ofNullable(clazz.cast(this.replaceUnhealthyInstances()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "LoadBalancersConfig": {
                return Optional.ofNullable(clazz.cast(this.loadBalancersConfig()));
            }
            case "InstancePoolsToUseCount": {
                return Optional.ofNullable(clazz.cast(this.instancePoolsToUseCount()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetRequestConfigData, T> g) {
        return obj -> g.apply((SpotFleetRequestConfigData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String onDemandAllocationStrategy;
        private SpotMaintenanceStrategies spotMaintenanceStrategies;
        private String clientToken;
        private String excessCapacityTerminationPolicy;
        private Double fulfilledCapacity;
        private Double onDemandFulfilledCapacity;
        private String iamFleetRole;
        private List<SpotFleetLaunchSpecification> launchSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private String spotPrice;
        private Integer targetCapacity;
        private Integer onDemandTargetCapacity;
        private String onDemandMaxTotalPrice;
        private String spotMaxTotalPrice;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;
        private String instanceInterruptionBehavior;
        private LoadBalancersConfig loadBalancersConfig;
        private Integer instancePoolsToUseCount;
        private String context;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            this.allocationStrategy(model.allocationStrategy);
            this.onDemandAllocationStrategy(model.onDemandAllocationStrategy);
            this.spotMaintenanceStrategies(model.spotMaintenanceStrategies);
            this.clientToken(model.clientToken);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.fulfilledCapacity(model.fulfilledCapacity);
            this.onDemandFulfilledCapacity(model.onDemandFulfilledCapacity);
            this.iamFleetRole(model.iamFleetRole);
            this.launchSpecifications(model.launchSpecifications);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.spotPrice(model.spotPrice);
            this.targetCapacity(model.targetCapacity);
            this.onDemandTargetCapacity(model.onDemandTargetCapacity);
            this.onDemandMaxTotalPrice(model.onDemandMaxTotalPrice);
            this.spotMaxTotalPrice(model.spotMaxTotalPrice);
            this.terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.loadBalancersConfig(model.loadBalancersConfig);
            this.instancePoolsToUseCount(model.instancePoolsToUseCount);
            this.context(model.context);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getOnDemandAllocationStrategy() {
            return this.onDemandAllocationStrategy;
        }

        @Override
        public final Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        @Override
        public final Builder onDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy(onDemandAllocationStrategy == null ? null : onDemandAllocationStrategy.toString());
            return this;
        }

        public final void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        }

        public final SpotMaintenanceStrategies.Builder getSpotMaintenanceStrategies() {
            return this.spotMaintenanceStrategies != null ? this.spotMaintenanceStrategies.toBuilder() : null;
        }

        @Override
        public final Builder spotMaintenanceStrategies(SpotMaintenanceStrategies spotMaintenanceStrategies) {
            this.spotMaintenanceStrategies = spotMaintenanceStrategies;
            return this;
        }

        public final void setSpotMaintenanceStrategies(SpotMaintenanceStrategies.BuilderImpl spotMaintenanceStrategies) {
            this.spotMaintenanceStrategies = spotMaintenanceStrategies != null ? spotMaintenanceStrategies.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final Double getOnDemandFulfilledCapacity() {
            return this.onDemandFulfilledCapacity;
        }

        @Override
        public final Builder onDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
            return this;
        }

        public final void setOnDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
        }

        public final String getIamFleetRole() {
            return this.iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        public final List<SpotFleetLaunchSpecification.Builder> getLaunchSpecifications() {
            List<SpotFleetLaunchSpecification.Builder> result = LaunchSpecsListCopier.copyToBuilder(this.launchSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
            this.launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder> ... launchSpecifications) {
            this.launchSpecifications(Stream.of(launchSpecifications).map(c -> (SpotFleetLaunchSpecification)((SpotFleetLaunchSpecification.Builder)SpotFleetLaunchSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification.BuilderImpl> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copyFromBuilder(launchSpecifications);
        }

        public final List<LaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            List<LaunchTemplateConfig.Builder> result = LaunchTemplateConfigListCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(LaunchTemplateConfig ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (LaunchTemplateConfig)((LaunchTemplateConfig.Builder)LaunchTemplateConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Integer getOnDemandTargetCapacity() {
            return this.onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        public final String getOnDemandMaxTotalPrice() {
            return this.onDemandMaxTotalPrice;
        }

        @Override
        public final Builder onDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
            this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
            return this;
        }

        public final void setOnDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
            this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
        }

        public final String getSpotMaxTotalPrice() {
            return this.spotMaxTotalPrice;
        }

        @Override
        public final Builder spotMaxTotalPrice(String spotMaxTotalPrice) {
            this.spotMaxTotalPrice = spotMaxTotalPrice;
            return this;
        }

        public final void setSpotMaxTotalPrice(String spotMaxTotalPrice) {
            this.spotMaxTotalPrice = spotMaxTotalPrice;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final LoadBalancersConfig.Builder getLoadBalancersConfig() {
            return this.loadBalancersConfig != null ? this.loadBalancersConfig.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancersConfig(LoadBalancersConfig loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig;
            return this;
        }

        public final void setLoadBalancersConfig(LoadBalancersConfig.BuilderImpl loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig != null ? loadBalancersConfig.build() : null;
        }

        public final Integer getInstancePoolsToUseCount() {
            return this.instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(AllocationStrategy var1);

        public Builder onDemandAllocationStrategy(String var1);

        public Builder onDemandAllocationStrategy(OnDemandAllocationStrategy var1);

        public Builder spotMaintenanceStrategies(SpotMaintenanceStrategies var1);

        default public Builder spotMaintenanceStrategies(Consumer<SpotMaintenanceStrategies.Builder> spotMaintenanceStrategies) {
            return this.spotMaintenanceStrategies((SpotMaintenanceStrategies)((SpotMaintenanceStrategies.Builder)SpotMaintenanceStrategies.builder().applyMutation(spotMaintenanceStrategies)).build());
        }

        public Builder clientToken(String var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder onDemandFulfilledCapacity(Double var1);

        public Builder iamFleetRole(String var1);

        public Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> var1);

        public Builder launchSpecifications(SpotFleetLaunchSpecification ... var1);

        public Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder> ... var1);

        public Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> var1);

        public Builder launchTemplateConfigs(LaunchTemplateConfig ... var1);

        public Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder> ... var1);

        public Builder spotPrice(String var1);

        public Builder targetCapacity(Integer var1);

        public Builder onDemandTargetCapacity(Integer var1);

        public Builder onDemandMaxTotalPrice(String var1);

        public Builder spotMaxTotalPrice(String var1);

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehavior var1);

        public Builder loadBalancersConfig(LoadBalancersConfig var1);

        default public Builder loadBalancersConfig(Consumer<LoadBalancersConfig.Builder> loadBalancersConfig) {
            return this.loadBalancersConfig((LoadBalancersConfig)((LoadBalancersConfig.Builder)LoadBalancersConfig.builder().applyMutation(loadBalancersConfig)).build());
        }

        public Builder instancePoolsToUseCount(Integer var1);

        public Builder context(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);
    }
}

