/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptReservedInstancesExchangeQuoteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AcceptReservedInstancesExchangeQuoteRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstanceIds").getter(AcceptReservedInstancesExchangeQuoteRequest.getter(AcceptReservedInstancesExchangeQuoteRequest::reservedInstanceIds)).setter(AcceptReservedInstancesExchangeQuoteRequest.setter(Builder::reservedInstanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").unmarshallLocationName("ReservedInstanceId").build(), ListTrait.builder().memberLocationName("ReservedInstanceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").unmarshallLocationName("ReservedInstanceId").build()}).build()).build()}).build();
    private static final SdkField<List<TargetConfigurationRequest>> TARGET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetConfigurations").getter(AcceptReservedInstancesExchangeQuoteRequest.getter(AcceptReservedInstancesExchangeQuoteRequest::targetConfigurations)).setter(AcceptReservedInstancesExchangeQuoteRequest.setter(Builder::targetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").unmarshallLocationName("TargetConfiguration").build(), ListTrait.builder().memberLocationName("TargetConfigurationRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationRequest").unmarshallLocationName("TargetConfigurationRequest").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCE_IDS_FIELD, TARGET_CONFIGURATIONS_FIELD));
    private final List<String> reservedInstanceIds;
    private final List<TargetConfigurationRequest> targetConfigurations;

    private AcceptReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public final boolean hasReservedInstanceIds() {
        return this.reservedInstanceIds != null && !(this.reservedInstanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> reservedInstanceIds() {
        return this.reservedInstanceIds;
    }

    public final boolean hasTargetConfigurations() {
        return this.targetConfigurations != null && !(this.targetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TargetConfigurationRequest> targetConfigurations() {
        return this.targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstanceIds() ? this.reservedInstanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetConfigurations() ? this.targetConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        AcceptReservedInstancesExchangeQuoteRequest other = (AcceptReservedInstancesExchangeQuoteRequest)((Object)obj);
        return this.hasReservedInstanceIds() == other.hasReservedInstanceIds() && Objects.equals(this.reservedInstanceIds(), other.reservedInstanceIds()) && this.hasTargetConfigurations() == other.hasTargetConfigurations() && Objects.equals(this.targetConfigurations(), other.targetConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptReservedInstancesExchangeQuoteRequest").add("ReservedInstanceIds", this.hasReservedInstanceIds() ? this.reservedInstanceIds() : null).add("TargetConfigurations", this.hasTargetConfigurations() ? this.targetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstanceIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceIds()));
            }
            case "TargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptReservedInstancesExchangeQuoteRequest, T> g) {
        return obj -> g.apply((AcceptReservedInstancesExchangeQuoteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> reservedInstanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<TargetConfigurationRequest> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptReservedInstancesExchangeQuoteRequest model) {
            super(model);
            this.reservedInstanceIds(model.reservedInstanceIds);
            this.targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            if (this.reservedInstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedInstanceIds;
        }

        @Override
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceIds(String ... reservedInstanceIds) {
            this.reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        public final List<TargetConfigurationRequest.Builder> getTargetConfigurations() {
            List<TargetConfigurationRequest.Builder> result = TargetConfigurationRequestSetCopier.copyToBuilder(this.targetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... targetConfigurations) {
            this.targetConfigurations(Stream.of(targetConfigurations).map(c -> (TargetConfigurationRequest)((TargetConfigurationRequest.Builder)TargetConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptReservedInstancesExchangeQuoteRequest build() {
            return new AcceptReservedInstancesExchangeQuoteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptReservedInstancesExchangeQuoteRequest> {
        public Builder reservedInstanceIds(Collection<String> var1);

        public Builder reservedInstanceIds(String ... var1);

        public Builder targetConfigurations(Collection<TargetConfigurationRequest> var1);

        public Builder targetConfigurations(TargetConfigurationRequest ... var1);

        public Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

