/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Protocol;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkInsightsPathRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNetworkInsightsPathRequest> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIp").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::sourceIp)).setter(CreateNetworkInsightsPathRequest.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").unmarshallLocationName("SourceIp").build()}).build();
    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIp").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::destinationIp)).setter(CreateNetworkInsightsPathRequest.setter(Builder::destinationIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIp").unmarshallLocationName("DestinationIp").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::source)).setter(CreateNetworkInsightsPathRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("Source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::destination)).setter(CreateNetworkInsightsPathRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("Destination").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::protocolAsString)).setter(CreateNetworkInsightsPathRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DestinationPort").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::destinationPort)).setter(CreateNetworkInsightsPathRequest.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").unmarshallLocationName("DestinationPort").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::tagSpecifications)).setter(CreateNetworkInsightsPathRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNetworkInsightsPathRequest.getter(CreateNetworkInsightsPathRequest::clientToken)).setter(CreateNetworkInsightsPathRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD, DESTINATION_IP_FIELD, SOURCE_FIELD, DESTINATION_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private final String sourceIp;
    private final String destinationIp;
    private final String source;
    private final String destination;
    private final String protocol;
    private final Integer destinationPort;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;

    private CreateNetworkInsightsPathRequest(BuilderImpl builder) {
        super(builder);
        this.sourceIp = builder.sourceIp;
        this.destinationIp = builder.destinationIp;
        this.source = builder.source;
        this.destination = builder.destination;
        this.protocol = builder.protocol;
        this.destinationPort = builder.destinationPort;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    public final String sourceIp() {
        return this.sourceIp;
    }

    public final String destinationIp() {
        return this.destinationIp;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInsightsPathRequest)) {
            return false;
        }
        CreateNetworkInsightsPathRequest other = (CreateNetworkInsightsPathRequest)((Object)obj);
        return Objects.equals(this.sourceIp(), other.sourceIp()) && Objects.equals(this.destinationIp(), other.destinationIp()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.destinationPort(), other.destinationPort()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkInsightsPathRequest").add("SourceIp", (Object)this.sourceIp()).add("DestinationIp", (Object)this.destinationIp()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("Protocol", (Object)this.protocolAsString()).add("DestinationPort", (Object)this.destinationPort()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIp()));
            }
            case "DestinationIp": {
                return Optional.ofNullable(clazz.cast(this.destinationIp()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInsightsPathRequest, T> g) {
        return obj -> g.apply((CreateNetworkInsightsPathRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String sourceIp;
        private String destinationIp;
        private String source;
        private String destination;
        private String protocol;
        private Integer destinationPort;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInsightsPathRequest model) {
            super(model);
            this.sourceIp(model.sourceIp);
            this.destinationIp(model.destinationIp);
            this.source(model.source);
            this.destination(model.destination);
            this.protocol(model.protocol);
            this.destinationPort(model.destinationPort);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        public final String getDestinationIp() {
            return this.destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInsightsPathRequest build() {
            return new CreateNetworkInsightsPathRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkInsightsPathRequest> {
        public Builder sourceIp(String var1);

        public Builder destinationIp(String var1);

        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder destinationPort(Integer var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

