/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;

public class DescribeVpcEndpointsPublisher
implements SdkPublisher<DescribeVpcEndpointsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcEndpointsPublisher(Ec2AsyncClient client, DescribeVpcEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcEndpointsPublisher(Ec2AsyncClient client, DescribeVpcEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcEndpoint> vpcEndpoints() {
        Function<DescribeVpcEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcEndpoints() != null) {
                return response.vpcEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVpcEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVpcEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcEndpointsResponse> {
        private DescribeVpcEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcEndpointsResponse> nextPage(DescribeVpcEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointsPublisher.this.client.describeVpcEndpoints(DescribeVpcEndpointsPublisher.this.firstRequest);
            }
            return DescribeVpcEndpointsPublisher.this.client.describeVpcEndpoints((DescribeVpcEndpointsRequest)((Object)DescribeVpcEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

