/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpnConnectionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeVpnConnectionsRequest.getter(DescribeVpnConnectionsRequest::filters)).setter(DescribeVpnConnectionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPN_CONNECTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpnConnectionIds").getter(DescribeVpnConnectionsRequest.getter(DescribeVpnConnectionsRequest::vpnConnectionIds)).setter(DescribeVpnConnectionsRequest.setter(Builder::vpnConnectionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build(), ListTrait.builder().memberLocationName("VpnConnectionId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, VPN_CONNECTION_IDS_FIELD));
    private final List<Filter> filters;
    private final List<String> vpnConnectionIds;

    private DescribeVpnConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.vpnConnectionIds = builder.vpnConnectionIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final boolean hasVpnConnectionIds() {
        return this.vpnConnectionIds != null && !(this.vpnConnectionIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpnConnectionIds() {
        return this.vpnConnectionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpnConnectionIds() ? this.vpnConnectionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasVpnConnectionIds() == other.hasVpnConnectionIds() && Objects.equals(this.vpnConnectionIds(), other.vpnConnectionIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpnConnectionsRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("VpnConnectionIds", this.hasVpnConnectionIds() ? this.vpnConnectionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "VpnConnectionIds": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnConnectionsRequest, T> g) {
        return obj -> g.apply((DescribeVpnConnectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpnConnectionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsRequest model) {
            super(model);
            this.filters(model.filters);
            this.vpnConnectionIds(model.vpnConnectionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (this.filters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnConnectionIds() {
            if (this.vpnConnectionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpnConnectionIds;
        }

        @Override
        public final Builder vpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnectionIds(String ... vpnConnectionIds) {
            this.vpnConnectionIds(Arrays.asList(vpnConnectionIds));
            return this;
        }

        public final void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpnConnectionsRequest build() {
            return new DescribeVpnConnectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder vpnConnectionIds(Collection<String> var1);

        public Builder vpnConnectionIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

