/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform;
import software.amazon.awssdk.services.ec2.model.CapacityReservationState;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy;
import software.amazon.awssdk.services.ec2.model.EndDateType;
import software.amazon.awssdk.services.ec2.model.InstanceMatchCriteria;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservation> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(CapacityReservation.getter(CapacityReservation::capacityReservationId)).setter(CapacityReservation.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(CapacityReservation.getter(CapacityReservation::ownerId)).setter(CapacityReservation.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationArn").getter(CapacityReservation.getter(CapacityReservation::capacityReservationArn)).setter(CapacityReservation.setter(Builder::capacityReservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationArn").unmarshallLocationName("capacityReservationArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CapacityReservation.getter(CapacityReservation::availabilityZoneId)).setter(CapacityReservation.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CapacityReservation.getter(CapacityReservation::instanceType)).setter(CapacityReservation.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(CapacityReservation.getter(CapacityReservation::instancePlatformAsString)).setter(CapacityReservation.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("instancePlatform").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CapacityReservation.getter(CapacityReservation::availabilityZone)).setter(CapacityReservation.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CapacityReservation.getter(CapacityReservation::tenancyAsString)).setter(CapacityReservation.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(CapacityReservation.getter(CapacityReservation::totalInstanceCount)).setter(CapacityReservation.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").unmarshallLocationName("totalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(CapacityReservation.getter(CapacityReservation::availableInstanceCount)).setter(CapacityReservation.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").unmarshallLocationName("availableInstanceCount").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(CapacityReservation.getter(CapacityReservation::ebsOptimized)).setter(CapacityReservation.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<Boolean> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EphemeralStorage").getter(CapacityReservation.getter(CapacityReservation::ephemeralStorage)).setter(CapacityReservation.setter(Builder::ephemeralStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").unmarshallLocationName("ephemeralStorage").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CapacityReservation.getter(CapacityReservation::stateAsString)).setter(CapacityReservation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(CapacityReservation.getter(CapacityReservation::startDate)).setter(CapacityReservation.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CapacityReservation.getter(CapacityReservation::endDate)).setter(CapacityReservation.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDateType").getter(CapacityReservation.getter(CapacityReservation::endDateTypeAsString)).setter(CapacityReservation.setter(Builder::endDateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType").unmarshallLocationName("endDateType").build()}).build();
    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMatchCriteria").getter(CapacityReservation.getter(CapacityReservation::instanceMatchCriteriaAsString)).setter(CapacityReservation.setter(Builder::instanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria").unmarshallLocationName("instanceMatchCriteria").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(CapacityReservation.getter(CapacityReservation::createDate)).setter(CapacityReservation.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CapacityReservation.getter(CapacityReservation::tags)).setter(CapacityReservation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, OWNER_ID_FIELD, CAPACITY_RESERVATION_ARN_FIELD, AVAILABILITY_ZONE_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD, TENANCY_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, EBS_OPTIMIZED_FIELD, EPHEMERAL_STORAGE_FIELD, STATE_FIELD, START_DATE_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, CREATE_DATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String capacityReservationId;
    private final String ownerId;
    private final String capacityReservationArn;
    private final String availabilityZoneId;
    private final String instanceType;
    private final String instancePlatform;
    private final String availabilityZone;
    private final String tenancy;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final Boolean ebsOptimized;
    private final Boolean ephemeralStorage;
    private final String state;
    private final Instant startDate;
    private final Instant endDate;
    private final String endDateType;
    private final String instanceMatchCriteria;
    private final Instant createDate;
    private final List<Tag> tags;

    private CapacityReservation(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.ownerId = builder.ownerId;
        this.capacityReservationArn = builder.capacityReservationArn;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.tenancy = builder.tenancy;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.ebsOptimized = builder.ebsOptimized;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.state = builder.state;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.createDate = builder.createDate;
        this.tags = builder.tags;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String capacityReservationArn() {
        return this.capacityReservationArn;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(this.instancePlatform);
    }

    public final String instancePlatformAsString() {
        return this.instancePlatform;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Boolean ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final CapacityReservationState state() {
        return CapacityReservationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final EndDateType endDateType() {
        return EndDateType.fromValue(this.endDateType);
    }

    public final String endDateTypeAsString() {
        return this.endDateType;
    }

    public final InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(this.instanceMatchCriteria);
    }

    public final String instanceMatchCriteriaAsString() {
        return this.instanceMatchCriteria;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservation)) {
            return false;
        }
        CapacityReservation other = (CapacityReservation)obj;
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.capacityReservationArn(), other.capacityReservationArn()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instancePlatformAsString(), other.instancePlatformAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.endDateTypeAsString(), other.endDateTypeAsString()) && Objects.equals(this.instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString()) && Objects.equals(this.createDate(), other.createDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservation").add("CapacityReservationId", (Object)this.capacityReservationId()).add("OwnerId", (Object)this.ownerId()).add("CapacityReservationArn", (Object)this.capacityReservationArn()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("InstanceType", (Object)this.instanceType()).add("InstancePlatform", (Object)this.instancePlatformAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Tenancy", (Object)this.tenancyAsString()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("State", (Object)this.stateAsString()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("EndDateType", (Object)this.endDateTypeAsString()).add("InstanceMatchCriteria", (Object)this.instanceMatchCriteriaAsString()).add("CreateDate", (Object)this.createDate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CapacityReservationArn": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationArn()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatformAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "EndDateType": {
                return Optional.ofNullable(clazz.cast(this.endDateTypeAsString()));
            }
            case "InstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.instanceMatchCriteriaAsString()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservation, T> g) {
        return obj -> g.apply((CapacityReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private String ownerId;
        private String capacityReservationArn;
        private String availabilityZoneId;
        private String instanceType;
        private String instancePlatform;
        private String availabilityZone;
        private String tenancy;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private Boolean ebsOptimized;
        private Boolean ephemeralStorage;
        private String state;
        private Instant startDate;
        private Instant endDate;
        private String endDateType;
        private String instanceMatchCriteria;
        private Instant createDate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservation model) {
            this.capacityReservationId(model.capacityReservationId);
            this.ownerId(model.ownerId);
            this.capacityReservationArn(model.capacityReservationArn);
            this.availabilityZoneId(model.availabilityZoneId);
            this.instanceType(model.instanceType);
            this.instancePlatform(model.instancePlatform);
            this.availabilityZone(model.availabilityZone);
            this.tenancy(model.tenancy);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.ebsOptimized(model.ebsOptimized);
            this.ephemeralStorage(model.ephemeralStorage);
            this.state(model.state);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.endDateType(model.endDateType);
            this.instanceMatchCriteria(model.instanceMatchCriteria);
            this.createDate(model.createDate);
            this.tags(model.tags);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCapacityReservationArn() {
            return this.capacityReservationArn;
        }

        @Override
        public final Builder capacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
            return this;
        }

        public final void setCapacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final void setEphemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateType() {
            return this.endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        public final String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CapacityReservation build() {
            return new CapacityReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservation> {
        public Builder capacityReservationId(String var1);

        public Builder ownerId(String var1);

        public Builder capacityReservationArn(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder instanceType(String var1);

        public Builder instancePlatform(String var1);

        public Builder instancePlatform(CapacityReservationInstancePlatform var1);

        public Builder availabilityZone(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(CapacityReservationTenancy var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder ephemeralStorage(Boolean var1);

        public Builder state(String var1);

        public Builder state(CapacityReservationState var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder endDateType(String var1);

        public Builder endDateType(EndDateType var1);

        public Builder instanceMatchCriteria(String var1);

        public Builder instanceMatchCriteria(InstanceMatchCriteria var1);

        public Builder createDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

