/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayMulticastDomainsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayMulticastDomainsResponse> {
    private static final SdkField<List<TransitGatewayMulticastDomain>> TRANSIT_GATEWAY_MULTICAST_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayMulticastDomains").getter(DescribeTransitGatewayMulticastDomainsResponse.getter(DescribeTransitGatewayMulticastDomainsResponse::transitGatewayMulticastDomains)).setter(DescribeTransitGatewayMulticastDomainsResponse.setter(Builder::transitGatewayMulticastDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomains").unmarshallLocationName("transitGatewayMulticastDomains").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayMulticastDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayMulticastDomainsResponse.getter(DescribeTransitGatewayMulticastDomainsResponse::nextToken)).setter(DescribeTransitGatewayMulticastDomainsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_MULTICAST_DOMAINS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayMulticastDomain> transitGatewayMulticastDomains;
    private final String nextToken;

    private DescribeTransitGatewayMulticastDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomains = builder.transitGatewayMulticastDomains;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTransitGatewayMulticastDomains() {
        return this.transitGatewayMulticastDomains != null && !(this.transitGatewayMulticastDomains instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayMulticastDomain> transitGatewayMulticastDomains() {
        return this.transitGatewayMulticastDomains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMulticastDomains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayMulticastDomainsResponse)) {
            return false;
        }
        DescribeTransitGatewayMulticastDomainsResponse other = (DescribeTransitGatewayMulticastDomainsResponse)((Object)obj);
        return Objects.equals(this.transitGatewayMulticastDomains(), other.transitGatewayMulticastDomains()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransitGatewayMulticastDomainsResponse").add("TransitGatewayMulticastDomains", this.transitGatewayMulticastDomains()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMulticastDomains": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMulticastDomains()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayMulticastDomainsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayMulticastDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayMulticastDomain> transitGatewayMulticastDomains = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayMulticastDomainsResponse model) {
            super(model);
            this.transitGatewayMulticastDomains(model.transitGatewayMulticastDomains);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayMulticastDomain.Builder> getTransitGatewayMulticastDomains() {
            return this.transitGatewayMulticastDomains != null ? (Collection)this.transitGatewayMulticastDomains.stream().map(TransitGatewayMulticastDomain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayMulticastDomains(Collection<TransitGatewayMulticastDomain> transitGatewayMulticastDomains) {
            this.transitGatewayMulticastDomains = TransitGatewayMulticastDomainListCopier.copy(transitGatewayMulticastDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayMulticastDomains(TransitGatewayMulticastDomain ... transitGatewayMulticastDomains) {
            this.transitGatewayMulticastDomains(Arrays.asList(transitGatewayMulticastDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayMulticastDomains(Consumer<TransitGatewayMulticastDomain.Builder> ... transitGatewayMulticastDomains) {
            this.transitGatewayMulticastDomains(Stream.of(transitGatewayMulticastDomains).map(c -> (TransitGatewayMulticastDomain)((TransitGatewayMulticastDomain.Builder)TransitGatewayMulticastDomain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayMulticastDomains(Collection<TransitGatewayMulticastDomain.BuilderImpl> transitGatewayMulticastDomains) {
            this.transitGatewayMulticastDomains = TransitGatewayMulticastDomainListCopier.copyFromBuilder(transitGatewayMulticastDomains);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTransitGatewayMulticastDomainsResponse build() {
            return new DescribeTransitGatewayMulticastDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayMulticastDomainsResponse> {
        public Builder transitGatewayMulticastDomains(Collection<TransitGatewayMulticastDomain> var1);

        public Builder transitGatewayMulticastDomains(TransitGatewayMulticastDomain ... var1);

        public Builder transitGatewayMulticastDomains(Consumer<TransitGatewayMulticastDomain.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

