/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNetworkInterfacePermissionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteNetworkInterfacePermissionRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_PERMISSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfacePermissionId").getter(DeleteNetworkInterfacePermissionRequest.getter(DeleteNetworkInterfacePermissionRequest::networkInterfacePermissionId)).setter(DeleteNetworkInterfacePermissionRequest.setter(Builder::networkInterfacePermissionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissionId").unmarshallLocationName("NetworkInterfacePermissionId").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Force").getter(DeleteNetworkInterfacePermissionRequest.getter(DeleteNetworkInterfacePermissionRequest::force)).setter(DeleteNetworkInterfacePermissionRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").unmarshallLocationName("Force").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_PERMISSION_ID_FIELD, FORCE_FIELD));
    private final String networkInterfacePermissionId;
    private final Boolean force;

    private DeleteNetworkInterfacePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.force = builder.force;
    }

    public final String networkInterfacePermissionId() {
        return this.networkInterfacePermissionId;
    }

    public final Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkInterfacePermissionRequest)) {
            return false;
        }
        DeleteNetworkInterfacePermissionRequest other = (DeleteNetworkInterfacePermissionRequest)((Object)obj);
        return Objects.equals(this.networkInterfacePermissionId(), other.networkInterfacePermissionId()) && Objects.equals(this.force(), other.force());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteNetworkInterfacePermissionRequest").add("NetworkInterfacePermissionId", (Object)this.networkInterfacePermissionId()).add("Force", (Object)this.force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissionId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacePermissionId()));
            }
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkInterfacePermissionRequest, T> g) {
        return obj -> g.apply((DeleteNetworkInterfacePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfacePermissionId;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkInterfacePermissionRequest model) {
            super(model);
            this.networkInterfacePermissionId(model.networkInterfacePermissionId);
            this.force(model.force);
        }

        public final String getNetworkInterfacePermissionId() {
            return this.networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkInterfacePermissionRequest build() {
            return new DeleteNetworkInterfacePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNetworkInterfacePermissionRequest> {
        public Builder networkInterfacePermissionId(String var1);

        public Builder force(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

