/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion;
import software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletionSetCopier;
import software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion;
import software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteQueuedReservedInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteQueuedReservedInstancesResponse> {
    private static final SdkField<List<SuccessfulQueuedPurchaseDeletion>> SUCCESSFUL_QUEUED_PURCHASE_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulQueuedPurchaseDeletions").getter(DeleteQueuedReservedInstancesResponse.getter(DeleteQueuedReservedInstancesResponse::successfulQueuedPurchaseDeletions)).setter(DeleteQueuedReservedInstancesResponse.setter(Builder::successfulQueuedPurchaseDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulQueuedPurchaseDeletionSet").unmarshallLocationName("successfulQueuedPurchaseDeletionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulQueuedPurchaseDeletion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<FailedQueuedPurchaseDeletion>> FAILED_QUEUED_PURCHASE_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedQueuedPurchaseDeletions").getter(DeleteQueuedReservedInstancesResponse.getter(DeleteQueuedReservedInstancesResponse::failedQueuedPurchaseDeletions)).setter(DeleteQueuedReservedInstancesResponse.setter(Builder::failedQueuedPurchaseDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedQueuedPurchaseDeletionSet").unmarshallLocationName("failedQueuedPurchaseDeletionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedQueuedPurchaseDeletion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_QUEUED_PURCHASE_DELETIONS_FIELD, FAILED_QUEUED_PURCHASE_DELETIONS_FIELD));
    private final List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions;
    private final List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions;

    private DeleteQueuedReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.successfulQueuedPurchaseDeletions = builder.successfulQueuedPurchaseDeletions;
        this.failedQueuedPurchaseDeletions = builder.failedQueuedPurchaseDeletions;
    }

    public boolean hasSuccessfulQueuedPurchaseDeletions() {
        return this.successfulQueuedPurchaseDeletions != null && !(this.successfulQueuedPurchaseDeletions instanceof SdkAutoConstructList);
    }

    public List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions() {
        return this.successfulQueuedPurchaseDeletions;
    }

    public boolean hasFailedQueuedPurchaseDeletions() {
        return this.failedQueuedPurchaseDeletions != null && !(this.failedQueuedPurchaseDeletions instanceof SdkAutoConstructList);
    }

    public List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions() {
        return this.failedQueuedPurchaseDeletions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulQueuedPurchaseDeletions() ? this.successfulQueuedPurchaseDeletions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedQueuedPurchaseDeletions() ? this.failedQueuedPurchaseDeletions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueuedReservedInstancesResponse)) {
            return false;
        }
        DeleteQueuedReservedInstancesResponse other = (DeleteQueuedReservedInstancesResponse)((Object)obj);
        return this.hasSuccessfulQueuedPurchaseDeletions() == other.hasSuccessfulQueuedPurchaseDeletions() && Objects.equals(this.successfulQueuedPurchaseDeletions(), other.successfulQueuedPurchaseDeletions()) && this.hasFailedQueuedPurchaseDeletions() == other.hasFailedQueuedPurchaseDeletions() && Objects.equals(this.failedQueuedPurchaseDeletions(), other.failedQueuedPurchaseDeletions());
    }

    public String toString() {
        return ToString.builder((String)"DeleteQueuedReservedInstancesResponse").add("SuccessfulQueuedPurchaseDeletions", this.hasSuccessfulQueuedPurchaseDeletions() ? this.successfulQueuedPurchaseDeletions() : null).add("FailedQueuedPurchaseDeletions", this.hasFailedQueuedPurchaseDeletions() ? this.failedQueuedPurchaseDeletions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulQueuedPurchaseDeletions": {
                return Optional.ofNullable(clazz.cast(this.successfulQueuedPurchaseDeletions()));
            }
            case "FailedQueuedPurchaseDeletions": {
                return Optional.ofNullable(clazz.cast(this.failedQueuedPurchaseDeletions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueuedReservedInstancesResponse, T> g) {
        return obj -> g.apply((DeleteQueuedReservedInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions = DefaultSdkAutoConstructList.getInstance();
        private List<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueuedReservedInstancesResponse model) {
            super(model);
            this.successfulQueuedPurchaseDeletions(model.successfulQueuedPurchaseDeletions);
            this.failedQueuedPurchaseDeletions(model.failedQueuedPurchaseDeletions);
        }

        public final Collection<SuccessfulQueuedPurchaseDeletion.Builder> getSuccessfulQueuedPurchaseDeletions() {
            if (this.successfulQueuedPurchaseDeletions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulQueuedPurchaseDeletions != null ? (Collection)this.successfulQueuedPurchaseDeletions.stream().map(SuccessfulQueuedPurchaseDeletion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulQueuedPurchaseDeletions(Collection<SuccessfulQueuedPurchaseDeletion> successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions = SuccessfulQueuedPurchaseDeletionSetCopier.copy(successfulQueuedPurchaseDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulQueuedPurchaseDeletions(SuccessfulQueuedPurchaseDeletion ... successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions(Arrays.asList(successfulQueuedPurchaseDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulQueuedPurchaseDeletions(Consumer<SuccessfulQueuedPurchaseDeletion.Builder> ... successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions(Stream.of(successfulQueuedPurchaseDeletions).map(c -> (SuccessfulQueuedPurchaseDeletion)((SuccessfulQueuedPurchaseDeletion.Builder)SuccessfulQueuedPurchaseDeletion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulQueuedPurchaseDeletions(Collection<SuccessfulQueuedPurchaseDeletion.BuilderImpl> successfulQueuedPurchaseDeletions) {
            this.successfulQueuedPurchaseDeletions = SuccessfulQueuedPurchaseDeletionSetCopier.copyFromBuilder(successfulQueuedPurchaseDeletions);
        }

        public final Collection<FailedQueuedPurchaseDeletion.Builder> getFailedQueuedPurchaseDeletions() {
            if (this.failedQueuedPurchaseDeletions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failedQueuedPurchaseDeletions != null ? (Collection)this.failedQueuedPurchaseDeletions.stream().map(FailedQueuedPurchaseDeletion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedQueuedPurchaseDeletions(Collection<FailedQueuedPurchaseDeletion> failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions = FailedQueuedPurchaseDeletionSetCopier.copy(failedQueuedPurchaseDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedQueuedPurchaseDeletions(FailedQueuedPurchaseDeletion ... failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions(Arrays.asList(failedQueuedPurchaseDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedQueuedPurchaseDeletions(Consumer<FailedQueuedPurchaseDeletion.Builder> ... failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions(Stream.of(failedQueuedPurchaseDeletions).map(c -> (FailedQueuedPurchaseDeletion)((FailedQueuedPurchaseDeletion.Builder)FailedQueuedPurchaseDeletion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedQueuedPurchaseDeletions(Collection<FailedQueuedPurchaseDeletion.BuilderImpl> failedQueuedPurchaseDeletions) {
            this.failedQueuedPurchaseDeletions = FailedQueuedPurchaseDeletionSetCopier.copyFromBuilder(failedQueuedPurchaseDeletions);
        }

        @Override
        public DeleteQueuedReservedInstancesResponse build() {
            return new DeleteQueuedReservedInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteQueuedReservedInstancesResponse> {
        public Builder successfulQueuedPurchaseDeletions(Collection<SuccessfulQueuedPurchaseDeletion> var1);

        public Builder successfulQueuedPurchaseDeletions(SuccessfulQueuedPurchaseDeletion ... var1);

        public Builder successfulQueuedPurchaseDeletions(Consumer<SuccessfulQueuedPurchaseDeletion.Builder> ... var1);

        public Builder failedQueuedPurchaseDeletions(Collection<FailedQueuedPurchaseDeletion> var1);

        public Builder failedQueuedPurchaseDeletions(FailedQueuedPurchaseDeletion ... var1);

        public Builder failedQueuedPurchaseDeletions(Consumer<FailedQueuedPurchaseDeletion.Builder> ... var1);
    }
}

