/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AnalysisAclRule;
import software.amazon.awssdk.services.ec2.model.AnalysisComponent;
import software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader;
import software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute;
import software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SequenceNumber").getter(PathComponent.getter(PathComponent::sequenceNumber)).setter(PathComponent.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").unmarshallLocationName("sequenceNumber").build()}).build();
    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AclRule").getter(PathComponent.getter(PathComponent::aclRule)).setter(PathComponent.setter(Builder::aclRule)).constructor(AnalysisAclRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule").unmarshallLocationName("aclRule").build()}).build();
    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Component").getter(PathComponent.getter(PathComponent::component)).setter(PathComponent.setter(Builder::component)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").unmarshallLocationName("component").build()}).build();
    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationVpc").getter(PathComponent.getter(PathComponent::destinationVpc)).setter(PathComponent.setter(Builder::destinationVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc").unmarshallLocationName("destinationVpc").build()}).build();
    private static final SdkField<AnalysisPacketHeader> OUTBOUND_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundHeader").getter(PathComponent.getter(PathComponent::outboundHeader)).setter(PathComponent.setter(Builder::outboundHeader)).constructor(AnalysisPacketHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHeader").unmarshallLocationName("outboundHeader").build()}).build();
    private static final SdkField<AnalysisPacketHeader> INBOUND_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InboundHeader").getter(PathComponent.getter(PathComponent::inboundHeader)).setter(PathComponent.setter(Builder::inboundHeader)).constructor(AnalysisPacketHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundHeader").unmarshallLocationName("inboundHeader").build()}).build();
    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableRoute").getter(PathComponent.getter(PathComponent::routeTableRoute)).setter(PathComponent.setter(Builder::routeTableRoute)).constructor(AnalysisRouteTableRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute").unmarshallLocationName("routeTableRoute").build()}).build();
    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityGroupRule").getter(PathComponent.getter(PathComponent::securityGroupRule)).setter(PathComponent.setter(Builder::securityGroupRule)).constructor(AnalysisSecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule").unmarshallLocationName("securityGroupRule").build()}).build();
    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceVpc").getter(PathComponent.getter(PathComponent::sourceVpc)).setter(PathComponent.setter(Builder::sourceVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc").unmarshallLocationName("sourceVpc").build()}).build();
    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(PathComponent.getter(PathComponent::subnet)).setter(PathComponent.setter(Builder::subnet)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(PathComponent.getter(PathComponent::vpc)).setter(PathComponent.setter(Builder::vpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_NUMBER_FIELD, ACL_RULE_FIELD, COMPONENT_FIELD, DESTINATION_VPC_FIELD, OUTBOUND_HEADER_FIELD, INBOUND_HEADER_FIELD, ROUTE_TABLE_ROUTE_FIELD, SECURITY_GROUP_RULE_FIELD, SOURCE_VPC_FIELD, SUBNET_FIELD, VPC_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer sequenceNumber;
    private final AnalysisAclRule aclRule;
    private final AnalysisComponent component;
    private final AnalysisComponent destinationVpc;
    private final AnalysisPacketHeader outboundHeader;
    private final AnalysisPacketHeader inboundHeader;
    private final AnalysisRouteTableRoute routeTableRoute;
    private final AnalysisSecurityGroupRule securityGroupRule;
    private final AnalysisComponent sourceVpc;
    private final AnalysisComponent subnet;
    private final AnalysisComponent vpc;

    private PathComponent(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.aclRule = builder.aclRule;
        this.component = builder.component;
        this.destinationVpc = builder.destinationVpc;
        this.outboundHeader = builder.outboundHeader;
        this.inboundHeader = builder.inboundHeader;
        this.routeTableRoute = builder.routeTableRoute;
        this.securityGroupRule = builder.securityGroupRule;
        this.sourceVpc = builder.sourceVpc;
        this.subnet = builder.subnet;
        this.vpc = builder.vpc;
    }

    public Integer sequenceNumber() {
        return this.sequenceNumber;
    }

    public AnalysisAclRule aclRule() {
        return this.aclRule;
    }

    public AnalysisComponent component() {
        return this.component;
    }

    public AnalysisComponent destinationVpc() {
        return this.destinationVpc;
    }

    public AnalysisPacketHeader outboundHeader() {
        return this.outboundHeader;
    }

    public AnalysisPacketHeader inboundHeader() {
        return this.inboundHeader;
    }

    public AnalysisRouteTableRoute routeTableRoute() {
        return this.routeTableRoute;
    }

    public AnalysisSecurityGroupRule securityGroupRule() {
        return this.securityGroupRule;
    }

    public AnalysisComponent sourceVpc() {
        return this.sourceVpc;
    }

    public AnalysisComponent subnet() {
        return this.subnet;
    }

    public AnalysisComponent vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.component());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent)obj;
        return Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.aclRule(), other.aclRule()) && Objects.equals(this.component(), other.component()) && Objects.equals(this.destinationVpc(), other.destinationVpc()) && Objects.equals(this.outboundHeader(), other.outboundHeader()) && Objects.equals(this.inboundHeader(), other.inboundHeader()) && Objects.equals(this.routeTableRoute(), other.routeTableRoute()) && Objects.equals(this.securityGroupRule(), other.securityGroupRule()) && Objects.equals(this.sourceVpc(), other.sourceVpc()) && Objects.equals(this.subnet(), other.subnet()) && Objects.equals(this.vpc(), other.vpc());
    }

    public String toString() {
        return ToString.builder((String)"PathComponent").add("SequenceNumber", (Object)this.sequenceNumber()).add("AclRule", (Object)this.aclRule()).add("Component", (Object)this.component()).add("DestinationVpc", (Object)this.destinationVpc()).add("OutboundHeader", (Object)this.outboundHeader()).add("InboundHeader", (Object)this.inboundHeader()).add("RouteTableRoute", (Object)this.routeTableRoute()).add("SecurityGroupRule", (Object)this.securityGroupRule()).add("SourceVpc", (Object)this.sourceVpc()).add("Subnet", (Object)this.subnet()).add("Vpc", (Object)this.vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "AclRule": {
                return Optional.ofNullable(clazz.cast(this.aclRule()));
            }
            case "Component": {
                return Optional.ofNullable(clazz.cast(this.component()));
            }
            case "DestinationVpc": {
                return Optional.ofNullable(clazz.cast(this.destinationVpc()));
            }
            case "OutboundHeader": {
                return Optional.ofNullable(clazz.cast(this.outboundHeader()));
            }
            case "InboundHeader": {
                return Optional.ofNullable(clazz.cast(this.inboundHeader()));
            }
            case "RouteTableRoute": {
                return Optional.ofNullable(clazz.cast(this.routeTableRoute()));
            }
            case "SecurityGroupRule": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRule()));
            }
            case "SourceVpc": {
                return Optional.ofNullable(clazz.cast(this.sourceVpc()));
            }
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer sequenceNumber;
        private AnalysisAclRule aclRule;
        private AnalysisComponent component;
        private AnalysisComponent destinationVpc;
        private AnalysisPacketHeader outboundHeader;
        private AnalysisPacketHeader inboundHeader;
        private AnalysisRouteTableRoute routeTableRoute;
        private AnalysisSecurityGroupRule securityGroupRule;
        private AnalysisComponent sourceVpc;
        private AnalysisComponent subnet;
        private AnalysisComponent vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            this.sequenceNumber(model.sequenceNumber);
            this.aclRule(model.aclRule);
            this.component(model.component);
            this.destinationVpc(model.destinationVpc);
            this.outboundHeader(model.outboundHeader);
            this.inboundHeader(model.inboundHeader);
            this.routeTableRoute(model.routeTableRoute);
            this.securityGroupRule(model.securityGroupRule);
            this.sourceVpc(model.sourceVpc);
            this.subnet(model.subnet);
            this.vpc(model.vpc);
        }

        public final Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return this.aclRule != null ? this.aclRule.toBuilder() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        public final AnalysisComponent.Builder getComponent() {
            return this.component != null ? this.component.toBuilder() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return this.destinationVpc != null ? this.destinationVpc.toBuilder() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        public final AnalysisPacketHeader.Builder getOutboundHeader() {
            return this.outboundHeader != null ? this.outboundHeader.toBuilder() : null;
        }

        @Override
        public final Builder outboundHeader(AnalysisPacketHeader outboundHeader) {
            this.outboundHeader = outboundHeader;
            return this;
        }

        public final void setOutboundHeader(AnalysisPacketHeader.BuilderImpl outboundHeader) {
            this.outboundHeader = outboundHeader != null ? outboundHeader.build() : null;
        }

        public final AnalysisPacketHeader.Builder getInboundHeader() {
            return this.inboundHeader != null ? this.inboundHeader.toBuilder() : null;
        }

        @Override
        public final Builder inboundHeader(AnalysisPacketHeader inboundHeader) {
            this.inboundHeader = inboundHeader;
            return this;
        }

        public final void setInboundHeader(AnalysisPacketHeader.BuilderImpl inboundHeader) {
            this.inboundHeader = inboundHeader != null ? inboundHeader.build() : null;
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return this.routeTableRoute != null ? this.routeTableRoute.toBuilder() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return this.securityGroupRule != null ? this.securityGroupRule.toBuilder() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return this.sourceVpc != null ? this.sourceVpc.toBuilder() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        public final AnalysisComponent.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public PathComponent build() {
            return new PathComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathComponent> {
        public Builder sequenceNumber(Integer var1);

        public Builder aclRule(AnalysisAclRule var1);

        default public Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return this.aclRule((AnalysisAclRule)((AnalysisAclRule.Builder)AnalysisAclRule.builder().applyMutation(aclRule)).build());
        }

        public Builder component(AnalysisComponent var1);

        default public Builder component(Consumer<AnalysisComponent.Builder> component) {
            return this.component((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(component)).build());
        }

        public Builder destinationVpc(AnalysisComponent var1);

        default public Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return this.destinationVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(destinationVpc)).build());
        }

        public Builder outboundHeader(AnalysisPacketHeader var1);

        default public Builder outboundHeader(Consumer<AnalysisPacketHeader.Builder> outboundHeader) {
            return this.outboundHeader((AnalysisPacketHeader)((AnalysisPacketHeader.Builder)AnalysisPacketHeader.builder().applyMutation(outboundHeader)).build());
        }

        public Builder inboundHeader(AnalysisPacketHeader var1);

        default public Builder inboundHeader(Consumer<AnalysisPacketHeader.Builder> inboundHeader) {
            return this.inboundHeader((AnalysisPacketHeader)((AnalysisPacketHeader.Builder)AnalysisPacketHeader.builder().applyMutation(inboundHeader)).build());
        }

        public Builder routeTableRoute(AnalysisRouteTableRoute var1);

        default public Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return this.routeTableRoute((AnalysisRouteTableRoute)((AnalysisRouteTableRoute.Builder)AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute)).build());
        }

        public Builder securityGroupRule(AnalysisSecurityGroupRule var1);

        default public Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return this.securityGroupRule((AnalysisSecurityGroupRule)((AnalysisSecurityGroupRule.Builder)AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule)).build());
        }

        public Builder sourceVpc(AnalysisComponent var1);

        default public Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return this.sourceVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(sourceVpc)).build());
        }

        public Builder subnet(AnalysisComponent var1);

        default public Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return this.subnet((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(subnet)).build());
        }

        public Builder vpc(AnalysisComponent var1);

        default public Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return this.vpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpc)).build());
        }
    }
}

