/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDefaultSubnetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateDefaultSubnetResponse> {
    private static final SdkField<Subnet> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(CreateDefaultSubnetResponse.getter(CreateDefaultSubnetResponse::subnet)).setter(CreateDefaultSubnetResponse.setter(Builder::subnet)).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_FIELD));
    private final Subnet subnet;

    private CreateDefaultSubnetResponse(BuilderImpl builder) {
        super(builder);
        this.subnet = builder.subnet;
    }

    public Subnet subnet() {
        return this.subnet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDefaultSubnetResponse)) {
            return false;
        }
        CreateDefaultSubnetResponse other = (CreateDefaultSubnetResponse)((Object)obj);
        return Objects.equals(this.subnet(), other.subnet());
    }

    public String toString() {
        return ToString.builder((String)"CreateDefaultSubnetResponse").add("Subnet", (Object)this.subnet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDefaultSubnetResponse, T> g) {
        return obj -> g.apply((CreateDefaultSubnetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Subnet subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDefaultSubnetResponse model) {
            super(model);
            this.subnet(model.subnet);
        }

        public final Subnet.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(Subnet.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public CreateDefaultSubnetResponse build() {
            return new CreateDefaultSubnetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDefaultSubnetResponse> {
        public Builder subnet(Subnet var1);

        default public Builder subnet(Consumer<Subnet.Builder> subnet) {
            return this.subnet((Subnet)((Subnet.Builder)Subnet.builder().applyMutation(subnet)).build());
        }
    }
}

