/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesIdListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteQueuedReservedInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteQueuedReservedInstancesRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCES_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstancesIds").getter(DeleteQueuedReservedInstancesRequest.getter(DeleteQueuedReservedInstancesRequest::reservedInstancesIds)).setter(DeleteQueuedReservedInstancesRequest.setter(Builder::reservedInstancesIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("ReservedInstancesId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_IDS_FIELD));
    private final List<String> reservedInstancesIds;

    private DeleteQueuedReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesIds = builder.reservedInstancesIds;
    }

    public boolean hasReservedInstancesIds() {
        return this.reservedInstancesIds != null && !(this.reservedInstancesIds instanceof SdkAutoConstructList);
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueuedReservedInstancesRequest)) {
            return false;
        }
        DeleteQueuedReservedInstancesRequest other = (DeleteQueuedReservedInstancesRequest)((Object)obj);
        return this.hasReservedInstancesIds() == other.hasReservedInstancesIds() && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteQueuedReservedInstancesRequest").add("ReservedInstancesIds", this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueuedReservedInstancesRequest, T> g) {
        return obj -> g.apply((DeleteQueuedReservedInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueuedReservedInstancesRequest model) {
            super(model);
            this.reservedInstancesIds(model.reservedInstancesIds);
        }

        public final Collection<String> getReservedInstancesIds() {
            if (this.reservedInstancesIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = DeleteQueuedReservedInstancesIdListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = DeleteQueuedReservedInstancesIdListCopier.copy(reservedInstancesIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteQueuedReservedInstancesRequest build() {
            return new DeleteQueuedReservedInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteQueuedReservedInstancesRequest> {
        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

