/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriceSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriceSchedule> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Active").getter(PriceSchedule.getter(PriceSchedule::active)).setter(PriceSchedule.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").unmarshallLocationName("active").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(PriceSchedule.getter(PriceSchedule::currencyCodeAsString)).setter(PriceSchedule.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<Double> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Price").getter(PriceSchedule.getter(PriceSchedule::price)).setter(PriceSchedule.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").unmarshallLocationName("price").build()}).build();
    private static final SdkField<Long> TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Term").getter(PriceSchedule.getter(PriceSchedule::term)).setter(PriceSchedule.setter(Builder::term)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Term").unmarshallLocationName("term").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD, CURRENCY_CODE_FIELD, PRICE_FIELD, TERM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean active;
    private final String currencyCode;
    private final Double price;
    private final Long term;

    private PriceSchedule(BuilderImpl builder) {
        this.active = builder.active;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.term = builder.term;
    }

    public Boolean active() {
        return this.active;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Double price() {
        return this.price;
    }

    public Long term() {
        return this.term;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.term());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceSchedule)) {
            return false;
        }
        PriceSchedule other = (PriceSchedule)obj;
        return Objects.equals(this.active(), other.active()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.term(), other.term());
    }

    public String toString() {
        return ToString.builder((String)"PriceSchedule").add("Active", (Object)this.active()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Price", (Object)this.price()).add("Term", (Object)this.term()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "Term": {
                return Optional.ofNullable(clazz.cast(this.term()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PriceSchedule, T> g) {
        return obj -> g.apply((PriceSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean active;
        private String currencyCode;
        private Double price;
        private Long term;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceSchedule model) {
            this.active(model.active);
            this.currencyCode(model.currencyCode);
            this.price(model.price);
            this.term(model.term);
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public final Long getTerm() {
            return this.term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        public PriceSchedule build() {
            return new PriceSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriceSchedule> {
        public Builder active(Boolean var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder price(Double var1);

        public Builder term(Long var1);
    }
}

