/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ReplacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotCapacityRebalance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotCapacityRebalance> {
    private static final SdkField<String> REPLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplacementStrategy").getter(SpotCapacityRebalance.getter(SpotCapacityRebalance::replacementStrategyAsString)).setter(SpotCapacityRebalance.setter(Builder::replacementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementStrategy").unmarshallLocationName("replacementStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACEMENT_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replacementStrategy;

    private SpotCapacityRebalance(BuilderImpl builder) {
        this.replacementStrategy = builder.replacementStrategy;
    }

    public ReplacementStrategy replacementStrategy() {
        return ReplacementStrategy.fromValue(this.replacementStrategy);
    }

    public String replacementStrategyAsString() {
        return this.replacementStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotCapacityRebalance)) {
            return false;
        }
        SpotCapacityRebalance other = (SpotCapacityRebalance)obj;
        return Objects.equals(this.replacementStrategyAsString(), other.replacementStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"SpotCapacityRebalance").add("ReplacementStrategy", (Object)this.replacementStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplacementStrategy": {
                return Optional.ofNullable(clazz.cast(this.replacementStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotCapacityRebalance, T> g) {
        return obj -> g.apply((SpotCapacityRebalance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replacementStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotCapacityRebalance model) {
            this.replacementStrategy(model.replacementStrategy);
        }

        public final String getReplacementStrategy() {
            return this.replacementStrategy;
        }

        @Override
        public final Builder replacementStrategy(String replacementStrategy) {
            this.replacementStrategy = replacementStrategy;
            return this;
        }

        @Override
        public final Builder replacementStrategy(ReplacementStrategy replacementStrategy) {
            this.replacementStrategy(replacementStrategy == null ? null : replacementStrategy.toString());
            return this;
        }

        public final void setReplacementStrategy(String replacementStrategy) {
            this.replacementStrategy = replacementStrategy;
        }

        public SpotCapacityRebalance build() {
            return new SpotCapacityRebalance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotCapacityRebalance> {
        public Builder replacementStrategy(String var1);

        public Builder replacementStrategy(ReplacementStrategy var1);
    }
}

