/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CustomerGatewayIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomerGatewaysRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
    private static final SdkField<List<String>> CUSTOMER_GATEWAY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerGatewayIds").getter(DescribeCustomerGatewaysRequest.getter(DescribeCustomerGatewaysRequest::customerGatewayIds)).setter(DescribeCustomerGatewaysRequest.setter(Builder::customerGatewayIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("CustomerGatewayId").build(), ListTrait.builder().memberLocationName("CustomerGatewayId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("CustomerGatewayId").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeCustomerGatewaysRequest.getter(DescribeCustomerGatewaysRequest::filters)).setter(DescribeCustomerGatewaysRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_IDS_FIELD, FILTERS_FIELD));
    private final List<String> customerGatewayIds;
    private final List<Filter> filters;

    private DescribeCustomerGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.customerGatewayIds = builder.customerGatewayIds;
        this.filters = builder.filters;
    }

    public boolean hasCustomerGatewayIds() {
        return this.customerGatewayIds != null && !(this.customerGatewayIds instanceof SdkAutoConstructList);
    }

    public List<String> customerGatewayIds() {
        return this.customerGatewayIds;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysRequest)) {
            return false;
        }
        DescribeCustomerGatewaysRequest other = (DescribeCustomerGatewaysRequest)((Object)obj);
        return Objects.equals(this.customerGatewayIds(), other.customerGatewayIds()) && Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCustomerGatewaysRequest").add("CustomerGatewayIds", this.customerGatewayIds()).add("Filters", this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayIds": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerGatewaysRequest, T> g) {
        return obj -> g.apply((DescribeCustomerGatewaysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> customerGatewayIds = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysRequest model) {
            super(model);
            this.customerGatewayIds(model.customerGatewayIds);
            this.filters(model.filters);
        }

        public final Collection<String> getCustomerGatewayIds() {
            return this.customerGatewayIds;
        }

        @Override
        public final Builder customerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayIds(String ... customerGatewayIds) {
            this.customerGatewayIds(Arrays.asList(customerGatewayIds));
            return this;
        }

        public final void setCustomerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCustomerGatewaysRequest build() {
            return new DescribeCustomerGatewaysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
        public Builder customerGatewayIds(Collection<String> var1);

        public Builder customerGatewayIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

