/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInterfaceAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNetworkInterfaceAttributeResponse> {
    private static final SdkField<NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(DescribeNetworkInterfaceAttributeResponse.getter(DescribeNetworkInterfaceAttributeResponse::attachment)).setter(DescribeNetworkInterfaceAttributeResponse.setter(Builder::attachment)).constructor(NetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Description").getter(DescribeNetworkInterfaceAttributeResponse.getter(DescribeNetworkInterfaceAttributeResponse::description)).setter(DescribeNetworkInterfaceAttributeResponse.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(DescribeNetworkInterfaceAttributeResponse.getter(DescribeNetworkInterfaceAttributeResponse::groups)).setter(DescribeNetworkInterfaceAttributeResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(DescribeNetworkInterfaceAttributeResponse.getter(DescribeNetworkInterfaceAttributeResponse::networkInterfaceId)).setter(DescribeNetworkInterfaceAttributeResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDestCheck").getter(DescribeNetworkInterfaceAttributeResponse.getter(DescribeNetworkInterfaceAttributeResponse::sourceDestCheck)).setter(DescribeNetworkInterfaceAttributeResponse.setter(Builder::sourceDestCheck)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD));
    private final NetworkInterfaceAttachment attachment;
    private final AttributeValue description;
    private final List<GroupIdentifier> groups;
    private final String networkInterfaceId;
    private final AttributeBooleanValue sourceDestCheck;

    private DescribeNetworkInterfaceAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public AttributeValue description() {
        return this.description;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public AttributeBooleanValue sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeResponse)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeResponse other = (DescribeNetworkInterfaceAttributeResponse)((Object)obj);
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNetworkInterfaceAttributeResponse").add("Attachment", (Object)this.attachment()).add("Description", (Object)this.description()).add("Groups", this.hasGroups() ? this.groups() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SourceDestCheck", (Object)this.sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfaceAttributeResponse, T> g) {
        return obj -> g.apply((DescribeNetworkInterfaceAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private NetworkInterfaceAttachment attachment;
        private AttributeValue description;
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private AttributeBooleanValue sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeResponse model) {
            super(model);
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return this.sourceDestCheck != null ? this.sourceDestCheck.toBuilder() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public DescribeNetworkInterfaceAttributeResponse build() {
            return new DescribeNetworkInterfaceAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeResponse> {
        public Builder attachment(NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachment)((NetworkInterfaceAttachment.Builder)NetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(AttributeBooleanValue var1);

        default public Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return this.sourceDestCheck((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(sourceDestCheck)).build());
        }
    }
}

