/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;

public class DescribeSpotInstanceRequestsPublisher
implements SdkPublisher<DescribeSpotInstanceRequestsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSpotInstanceRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSpotInstanceRequestsPublisher(Ec2AsyncClient client, DescribeSpotInstanceRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSpotInstanceRequestsPublisher(Ec2AsyncClient client, DescribeSpotInstanceRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSpotInstanceRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSpotInstanceRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpotInstanceRequest> spotInstanceRequests() {
        Function<DescribeSpotInstanceRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotInstanceRequests() != null) {
                return response.spotInstanceRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSpotInstanceRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSpotInstanceRequestsResponseFetcher
    implements AsyncPageFetcher<DescribeSpotInstanceRequestsResponse> {
        private DescribeSpotInstanceRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotInstanceRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSpotInstanceRequestsResponse> nextPage(DescribeSpotInstanceRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotInstanceRequestsPublisher.this.client.describeSpotInstanceRequests(DescribeSpotInstanceRequestsPublisher.this.firstRequest);
            }
            return DescribeSpotInstanceRequestsPublisher.this.client.describeSpotInstanceRequests((DescribeSpotInstanceRequestsRequest)((Object)DescribeSpotInstanceRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

