/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LoadPermission;
import software.amazon.awssdk.services.ec2.model.LoadPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FpgaImageAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FpgaImageAttribute> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FpgaImageId").getter(FpgaImageAttribute.getter(FpgaImageAttribute::fpgaImageId)).setter(FpgaImageAttribute.setter(Builder::fpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("fpgaImageId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FpgaImageAttribute.getter(FpgaImageAttribute::name)).setter(FpgaImageAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FpgaImageAttribute.getter(FpgaImageAttribute::description)).setter(FpgaImageAttribute.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<LoadPermission>> LOAD_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadPermissions").getter(FpgaImageAttribute.getter(FpgaImageAttribute::loadPermissions)).setter(FpgaImageAttribute.setter(Builder::loadPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadPermissions").unmarshallLocationName("loadPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(FpgaImageAttribute.getter(FpgaImageAttribute::productCodes)).setter(FpgaImageAttribute.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOAD_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fpgaImageId;
    private final String name;
    private final String description;
    private final List<LoadPermission> loadPermissions;
    private final List<ProductCode> productCodes;

    private FpgaImageAttribute(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.name = builder.name;
        this.description = builder.description;
        this.loadPermissions = builder.loadPermissions;
        this.productCodes = builder.productCodes;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasLoadPermissions() {
        return this.loadPermissions != null && !(this.loadPermissions instanceof SdkAutoConstructList);
    }

    public List<LoadPermission> loadPermissions() {
        return this.loadPermissions;
    }

    public boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageAttribute)) {
            return false;
        }
        FpgaImageAttribute other = (FpgaImageAttribute)obj;
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.loadPermissions(), other.loadPermissions()) && Objects.equals(this.productCodes(), other.productCodes());
    }

    public String toString() {
        return ToString.builder((String)"FpgaImageAttribute").add("FpgaImageId", (Object)this.fpgaImageId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LoadPermissions", this.loadPermissions()).add("ProductCodes", this.productCodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LoadPermissions": {
                return Optional.ofNullable(clazz.cast(this.loadPermissions()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaImageAttribute, T> g) {
        return obj -> g.apply((FpgaImageAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String name;
        private String description;
        private List<LoadPermission> loadPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageAttribute model) {
            this.fpgaImageId(model.fpgaImageId);
            this.name(model.name);
            this.description(model.description);
            this.loadPermissions(model.loadPermissions);
            this.productCodes(model.productCodes);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<LoadPermission.Builder> getLoadPermissions() {
            return this.loadPermissions != null ? (Collection)this.loadPermissions.stream().map(LoadPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadPermissions(Collection<LoadPermission> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copy(loadPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(LoadPermission ... loadPermissions) {
            this.loadPermissions(Arrays.asList(loadPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(Consumer<LoadPermission.Builder> ... loadPermissions) {
            this.loadPermissions(Stream.of(loadPermissions).map(c -> (LoadPermission)((LoadPermission.Builder)LoadPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadPermissions(Collection<LoadPermission.BuilderImpl> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copyFromBuilder(loadPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public FpgaImageAttribute build() {
            return new FpgaImageAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FpgaImageAttribute> {
        public Builder fpgaImageId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder loadPermissions(Collection<LoadPermission> var1);

        public Builder loadPermissions(LoadPermission ... var1);

        public Builder loadPermissions(Consumer<LoadPermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);
    }
}

