/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskImageDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskImageDescription> {
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(DiskImageDescription.getter(DiskImageDescription::checksum)).setter(DiskImageDescription.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Checksum").unmarshallLocationName("checksum").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(DiskImageDescription.getter(DiskImageDescription::formatAsString)).setter(DiskImageDescription.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("format").build()}).build();
    private static final SdkField<String> IMPORT_MANIFEST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportManifestUrl").getter(DiskImageDescription.getter(DiskImageDescription::importManifestUrl)).setter(DiskImageDescription.setter(Builder::importManifestUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportManifestUrl").unmarshallLocationName("importManifestUrl").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(DiskImageDescription.getter(DiskImageDescription::size)).setter(DiskImageDescription.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").unmarshallLocationName("size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_FIELD, FORMAT_FIELD, IMPORT_MANIFEST_URL_FIELD, SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String checksum;
    private final String format;
    private final String importManifestUrl;
    private final Long size;

    private DiskImageDescription(BuilderImpl builder) {
        this.checksum = builder.checksum;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
        this.size = builder.size;
    }

    public String checksum() {
        return this.checksum;
    }

    public DiskImageFormat format() {
        return DiskImageFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String importManifestUrl() {
        return this.importManifestUrl;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importManifestUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDescription)) {
            return false;
        }
        DiskImageDescription other = (DiskImageDescription)obj;
        return Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.importManifestUrl(), other.importManifestUrl()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        return ToString.builder((String)"DiskImageDescription").add("Checksum", (Object)this.checksum()).add("Format", (Object)this.formatAsString()).add("ImportManifestUrl", (Object)this.importManifestUrl()).add("Size", (Object)this.size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "ImportManifestUrl": {
                return Optional.ofNullable(clazz.cast(this.importManifestUrl()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskImageDescription, T> g) {
        return obj -> g.apply((DiskImageDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checksum;
        private String format;
        private String importManifestUrl;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDescription model) {
            this.checksum(model.checksum);
            this.format(model.format);
            this.importManifestUrl(model.importManifestUrl);
            this.size(model.size);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getImportManifestUrl() {
            return this.importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public DiskImageDescription build() {
            return new DiskImageDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskImageDescription> {
        public Builder checksum(String var1);

        public Builder format(String var1);

        public Builder format(DiskImageFormat var1);

        public Builder importManifestUrl(String var1);

        public Builder size(Long var1);
    }
}

