/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayAttachmentsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayAttachmentsResponse> {
    private static final SdkField<List<TransitGatewayAttachment>> TRANSIT_GATEWAY_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayAttachments").getter(DescribeTransitGatewayAttachmentsResponse.getter(DescribeTransitGatewayAttachmentsResponse::transitGatewayAttachments)).setter(DescribeTransitGatewayAttachmentsResponse.setter(Builder::transitGatewayAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachments").unmarshallLocationName("transitGatewayAttachments").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayAttachmentsResponse.getter(DescribeTransitGatewayAttachmentsResponse::nextToken)).setter(DescribeTransitGatewayAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayAttachment> transitGatewayAttachments;
    private final String nextToken;

    private DescribeTransitGatewayAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachments = builder.transitGatewayAttachments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTransitGatewayAttachments() {
        return this.transitGatewayAttachments != null && !(this.transitGatewayAttachments instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayAttachment> transitGatewayAttachments() {
        return this.transitGatewayAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayAttachmentsResponse)) {
            return false;
        }
        DescribeTransitGatewayAttachmentsResponse other = (DescribeTransitGatewayAttachmentsResponse)((Object)obj);
        return Objects.equals(this.transitGatewayAttachments(), other.transitGatewayAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransitGatewayAttachmentsResponse").add("TransitGatewayAttachments", this.transitGatewayAttachments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachments": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayAttachment> transitGatewayAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayAttachmentsResponse model) {
            super(model);
            this.transitGatewayAttachments(model.transitGatewayAttachments);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayAttachment.Builder> getTransitGatewayAttachments() {
            return this.transitGatewayAttachments != null ? (Collection)this.transitGatewayAttachments.stream().map(TransitGatewayAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayAttachments(Collection<TransitGatewayAttachment> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayAttachmentListCopier.copy(transitGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayAttachments(TransitGatewayAttachment ... transitGatewayAttachments) {
            this.transitGatewayAttachments(Arrays.asList(transitGatewayAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayAttachments(Consumer<TransitGatewayAttachment.Builder> ... transitGatewayAttachments) {
            this.transitGatewayAttachments(Stream.of(transitGatewayAttachments).map(c -> (TransitGatewayAttachment)((TransitGatewayAttachment.Builder)TransitGatewayAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayAttachments(Collection<TransitGatewayAttachment.BuilderImpl> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayAttachmentListCopier.copyFromBuilder(transitGatewayAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTransitGatewayAttachmentsResponse build() {
            return new DescribeTransitGatewayAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayAttachmentsResponse> {
        public Builder transitGatewayAttachments(Collection<TransitGatewayAttachment> var1);

        public Builder transitGatewayAttachments(TransitGatewayAttachment ... var1);

        public Builder transitGatewayAttachments(Consumer<TransitGatewayAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

