/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMulticastDeregisteredGroupSources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMulticastDeregisteredGroupSources> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayMulticastDeregisteredGroupSources.getter(TransitGatewayMulticastDeregisteredGroupSources::transitGatewayMulticastDomainId)).setter(TransitGatewayMulticastDeregisteredGroupSources.setter(Builder::transitGatewayMulticastDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId").unmarshallLocationName("transitGatewayMulticastDomainId").build()}).build();
    private static final SdkField<List<String>> DEREGISTERED_NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransitGatewayMulticastDeregisteredGroupSources.getter(TransitGatewayMulticastDeregisteredGroupSources::deregisteredNetworkInterfaceIds)).setter(TransitGatewayMulticastDeregisteredGroupSources.setter(Builder::deregisteredNetworkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregisteredNetworkInterfaceIds").unmarshallLocationName("deregisteredNetworkInterfaceIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayMulticastDeregisteredGroupSources.getter(TransitGatewayMulticastDeregisteredGroupSources::groupIpAddress)).setter(TransitGatewayMulticastDeregisteredGroupSources.setter(Builder::groupIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress").unmarshallLocationName("groupIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, DEREGISTERED_NETWORK_INTERFACE_IDS_FIELD, GROUP_IP_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayMulticastDomainId;
    private final List<String> deregisteredNetworkInterfaceIds;
    private final String groupIpAddress;

    private TransitGatewayMulticastDeregisteredGroupSources(BuilderImpl builder) {
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.deregisteredNetworkInterfaceIds = builder.deregisteredNetworkInterfaceIds;
        this.groupIpAddress = builder.groupIpAddress;
    }

    public String transitGatewayMulticastDomainId() {
        return this.transitGatewayMulticastDomainId;
    }

    public boolean hasDeregisteredNetworkInterfaceIds() {
        return this.deregisteredNetworkInterfaceIds != null && !(this.deregisteredNetworkInterfaceIds instanceof SdkAutoConstructList);
    }

    public List<String> deregisteredNetworkInterfaceIds() {
        return this.deregisteredNetworkInterfaceIds;
    }

    public String groupIpAddress() {
        return this.groupIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregisteredNetworkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDeregisteredGroupSources)) {
            return false;
        }
        TransitGatewayMulticastDeregisteredGroupSources other = (TransitGatewayMulticastDeregisteredGroupSources)obj;
        return Objects.equals(this.transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId()) && Objects.equals(this.deregisteredNetworkInterfaceIds(), other.deregisteredNetworkInterfaceIds()) && Objects.equals(this.groupIpAddress(), other.groupIpAddress());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayMulticastDeregisteredGroupSources").add("TransitGatewayMulticastDomainId", (Object)this.transitGatewayMulticastDomainId()).add("DeregisteredNetworkInterfaceIds", this.deregisteredNetworkInterfaceIds()).add("GroupIpAddress", (Object)this.groupIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMulticastDomainId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMulticastDomainId()));
            }
            case "DeregisteredNetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.deregisteredNetworkInterfaceIds()));
            }
            case "GroupIpAddress": {
                return Optional.ofNullable(clazz.cast(this.groupIpAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDeregisteredGroupSources, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDeregisteredGroupSources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayMulticastDomainId;
        private List<String> deregisteredNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String groupIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDeregisteredGroupSources model) {
            this.transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            this.deregisteredNetworkInterfaceIds(model.deregisteredNetworkInterfaceIds);
            this.groupIpAddress(model.groupIpAddress);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        public final Collection<String> getDeregisteredNetworkInterfaceIds() {
            return this.deregisteredNetworkInterfaceIds;
        }

        @Override
        public final Builder deregisteredNetworkInterfaceIds(Collection<String> deregisteredNetworkInterfaceIds) {
            this.deregisteredNetworkInterfaceIds = ValueStringListCopier.copy(deregisteredNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deregisteredNetworkInterfaceIds(String ... deregisteredNetworkInterfaceIds) {
            this.deregisteredNetworkInterfaceIds(Arrays.asList(deregisteredNetworkInterfaceIds));
            return this;
        }

        public final void setDeregisteredNetworkInterfaceIds(Collection<String> deregisteredNetworkInterfaceIds) {
            this.deregisteredNetworkInterfaceIds = ValueStringListCopier.copy(deregisteredNetworkInterfaceIds);
        }

        public final String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        public TransitGatewayMulticastDeregisteredGroupSources build() {
            return new TransitGatewayMulticastDeregisteredGroupSources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMulticastDeregisteredGroupSources> {
        public Builder transitGatewayMulticastDomainId(String var1);

        public Builder deregisteredNetworkInterfaceIds(Collection<String> var1);

        public Builder deregisteredNetworkInterfaceIds(String ... var1);

        public Builder groupIpAddress(String var1);
    }
}

