/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ExecutableByStringListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ImageIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeImagesRequest> {
    private static final SdkField<List<String>> EXECUTABLE_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImagesRequest.getter(DescribeImagesRequest::executableUsers)).setter(DescribeImagesRequest.setter(Builder::executableUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutableBy").unmarshallLocationName("ExecutableBy").build(), ListTrait.builder().memberLocationName("ExecutableBy").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutableBy").unmarshallLocationName("ExecutableBy").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImagesRequest.getter(DescribeImagesRequest::filters)).setter(DescribeImagesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImagesRequest.getter(DescribeImagesRequest::imageIds)).setter(DescribeImagesRequest.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build(), ListTrait.builder().memberLocationName("ImageId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImagesRequest.getter(DescribeImagesRequest::owners)).setter(DescribeImagesRequest.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build(), ListTrait.builder().memberLocationName("Owner").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTABLE_USERS_FIELD, FILTERS_FIELD, IMAGE_IDS_FIELD, OWNERS_FIELD));
    private final List<String> executableUsers;
    private final List<Filter> filters;
    private final List<String> imageIds;
    private final List<String> owners;

    private DescribeImagesRequest(BuilderImpl builder) {
        super(builder);
        this.executableUsers = builder.executableUsers;
        this.filters = builder.filters;
        this.imageIds = builder.imageIds;
        this.owners = builder.owners;
    }

    public boolean hasExecutableUsers() {
        return this.executableUsers != null && !(this.executableUsers instanceof SdkAutoConstructList);
    }

    public List<String> executableUsers() {
        return this.executableUsers;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public List<String> imageIds() {
        return this.imageIds;
    }

    public boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public List<String> owners() {
        return this.owners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executableUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.owners());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest)((Object)obj);
        return Objects.equals(this.executableUsers(), other.executableUsers()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.owners(), other.owners());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImagesRequest").add("ExecutableUsers", this.executableUsers()).add("Filters", this.filters()).add("ImageIds", this.imageIds()).add("Owners", this.owners()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutableUsers": {
                return Optional.ofNullable(clazz.cast(this.executableUsers()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ImageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "Owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesRequest, T> g) {
        return obj -> g.apply((DescribeImagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> executableUsers = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> owners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            super(model);
            this.executableUsers(model.executableUsers);
            this.filters(model.filters);
            this.imageIds(model.imageIds);
            this.owners(model.owners);
        }

        public final Collection<String> getExecutableUsers() {
            return this.executableUsers;
        }

        @Override
        public final Builder executableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executableUsers(String ... executableUsers) {
            this.executableUsers(Arrays.asList(executableUsers));
            return this;
        }

        public final void setExecutableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
        }

        public final Collection<String> getOwners() {
            return this.owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImagesRequest> {
        public Builder executableUsers(Collection<String> var1);

        public Builder executableUsers(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

