/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CopyTagsFromSource;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSnapshotsRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::description)).setter(CreateSnapshotsRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<InstanceSpecification> INSTANCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::instanceSpecification)).setter(CreateSnapshotsRequest.setter(Builder::instanceSpecification)).constructor(InstanceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSpecification").unmarshallLocationName("InstanceSpecification").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::tagSpecifications)).setter(CreateSnapshotsRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> COPY_TAGS_FROM_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::copyTagsFromSourceAsString)).setter(CreateSnapshotsRequest.setter(Builder::copyTagsFromSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsFromSource").unmarshallLocationName("CopyTagsFromSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, INSTANCE_SPECIFICATION_FIELD, TAG_SPECIFICATIONS_FIELD, COPY_TAGS_FROM_SOURCE_FIELD));
    private final String description;
    private final InstanceSpecification instanceSpecification;
    private final List<TagSpecification> tagSpecifications;
    private final String copyTagsFromSource;

    private CreateSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.instanceSpecification = builder.instanceSpecification;
        this.tagSpecifications = builder.tagSpecifications;
        this.copyTagsFromSource = builder.copyTagsFromSource;
    }

    public String description() {
        return this.description;
    }

    public InstanceSpecification instanceSpecification() {
        return this.instanceSpecification;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public CopyTagsFromSource copyTagsFromSource() {
        return CopyTagsFromSource.fromValue(this.copyTagsFromSource);
    }

    public String copyTagsFromSourceAsString() {
        return this.copyTagsFromSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsFromSourceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotsRequest)) {
            return false;
        }
        CreateSnapshotsRequest other = (CreateSnapshotsRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceSpecification(), other.instanceSpecification()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.copyTagsFromSourceAsString(), other.copyTagsFromSourceAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateSnapshotsRequest").add("Description", (Object)this.description()).add("InstanceSpecification", (Object)this.instanceSpecification()).add("TagSpecifications", this.tagSpecifications()).add("CopyTagsFromSource", (Object)this.copyTagsFromSourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceSpecification": {
                return Optional.ofNullable(clazz.cast(this.instanceSpecification()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "CopyTagsFromSource": {
                return Optional.ofNullable(clazz.cast(this.copyTagsFromSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotsRequest, T> g) {
        return obj -> g.apply((CreateSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private InstanceSpecification instanceSpecification;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String copyTagsFromSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotsRequest model) {
            super(model);
            this.description(model.description);
            this.instanceSpecification(model.instanceSpecification);
            this.tagSpecifications(model.tagSpecifications);
            this.copyTagsFromSource(model.copyTagsFromSource);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final InstanceSpecification.Builder getInstanceSpecification() {
            return this.instanceSpecification != null ? this.instanceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder instanceSpecification(InstanceSpecification instanceSpecification) {
            this.instanceSpecification = instanceSpecification;
            return this;
        }

        public final void setInstanceSpecification(InstanceSpecification.BuilderImpl instanceSpecification) {
            this.instanceSpecification = instanceSpecification != null ? instanceSpecification.build() : null;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getCopyTagsFromSource() {
            return this.copyTagsFromSource;
        }

        @Override
        public final Builder copyTagsFromSource(String copyTagsFromSource) {
            this.copyTagsFromSource = copyTagsFromSource;
            return this;
        }

        @Override
        public final Builder copyTagsFromSource(CopyTagsFromSource copyTagsFromSource) {
            this.copyTagsFromSource(copyTagsFromSource == null ? null : copyTagsFromSource.toString());
            return this;
        }

        public final void setCopyTagsFromSource(String copyTagsFromSource) {
            this.copyTagsFromSource = copyTagsFromSource;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotsRequest build() {
            return new CreateSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotsRequest> {
        public Builder description(String var1);

        public Builder instanceSpecification(InstanceSpecification var1);

        default public Builder instanceSpecification(Consumer<InstanceSpecification.Builder> instanceSpecification) {
            return this.instanceSpecification((InstanceSpecification)((InstanceSpecification.Builder)InstanceSpecification.builder().applyMutation(instanceSpecification)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder copyTagsFromSource(String var1);

        public Builder copyTagsFromSource(CopyTagsFromSource var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

