/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FastSnapshotRestoreStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableFastSnapshotRestoreSuccessItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisableFastSnapshotRestoreSuccessItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::snapshotId)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::availabilityZone)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::stateAsString)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::stateTransitionReason)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").unmarshallLocationName("stateTransitionReason").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::ownerId)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::ownerAlias)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::ownerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").unmarshallLocationName("ownerAlias").build()}).build();
    private static final SdkField<Instant> ENABLING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::enablingTime)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::enablingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablingTime").unmarshallLocationName("enablingTime").build()}).build();
    private static final SdkField<Instant> OPTIMIZING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::optimizingTime)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::optimizingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizingTime").unmarshallLocationName("optimizingTime").build()}).build();
    private static final SdkField<Instant> ENABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::enabledTime)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::enabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledTime").unmarshallLocationName("enabledTime").build()}).build();
    private static final SdkField<Instant> DISABLING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::disablingTime)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::disablingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisablingTime").unmarshallLocationName("disablingTime").build()}).build();
    private static final SdkField<Instant> DISABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DisableFastSnapshotRestoreSuccessItem.getter(DisableFastSnapshotRestoreSuccessItem::disabledTime)).setter(DisableFastSnapshotRestoreSuccessItem.setter(Builder::disabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledTime").unmarshallLocationName("disabledTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, OWNER_ID_FIELD, OWNER_ALIAS_FIELD, ENABLING_TIME_FIELD, OPTIMIZING_TIME_FIELD, ENABLED_TIME_FIELD, DISABLING_TIME_FIELD, DISABLED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final String availabilityZone;
    private final String state;
    private final String stateTransitionReason;
    private final String ownerId;
    private final String ownerAlias;
    private final Instant enablingTime;
    private final Instant optimizingTime;
    private final Instant enabledTime;
    private final Instant disablingTime;
    private final Instant disabledTime;

    private DisableFastSnapshotRestoreSuccessItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.enablingTime = builder.enablingTime;
        this.optimizingTime = builder.optimizingTime;
        this.enabledTime = builder.enabledTime;
        this.disablingTime = builder.disablingTime;
        this.disabledTime = builder.disabledTime;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public FastSnapshotRestoreStateCode state() {
        return FastSnapshotRestoreStateCode.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public Instant enablingTime() {
        return this.enablingTime;
    }

    public Instant optimizingTime() {
        return this.optimizingTime;
    }

    public Instant enabledTime() {
        return this.enabledTime;
    }

    public Instant disablingTime() {
        return this.disablingTime;
    }

    public Instant disabledTime() {
        return this.disabledTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.disablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoreSuccessItem)) {
            return false;
        }
        DisableFastSnapshotRestoreSuccessItem other = (DisableFastSnapshotRestoreSuccessItem)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ownerAlias(), other.ownerAlias()) && Objects.equals(this.enablingTime(), other.enablingTime()) && Objects.equals(this.optimizingTime(), other.optimizingTime()) && Objects.equals(this.enabledTime(), other.enabledTime()) && Objects.equals(this.disablingTime(), other.disablingTime()) && Objects.equals(this.disabledTime(), other.disabledTime());
    }

    public String toString() {
        return ToString.builder((String)"DisableFastSnapshotRestoreSuccessItem").add("SnapshotId", (Object)this.snapshotId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("State", (Object)this.stateAsString()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("OwnerId", (Object)this.ownerId()).add("OwnerAlias", (Object)this.ownerAlias()).add("EnablingTime", (Object)this.enablingTime()).add("OptimizingTime", (Object)this.optimizingTime()).add("EnabledTime", (Object)this.enabledTime()).add("DisablingTime", (Object)this.disablingTime()).add("DisabledTime", (Object)this.disabledTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "OwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.ownerAlias()));
            }
            case "EnablingTime": {
                return Optional.ofNullable(clazz.cast(this.enablingTime()));
            }
            case "OptimizingTime": {
                return Optional.ofNullable(clazz.cast(this.optimizingTime()));
            }
            case "EnabledTime": {
                return Optional.ofNullable(clazz.cast(this.enabledTime()));
            }
            case "DisablingTime": {
                return Optional.ofNullable(clazz.cast(this.disablingTime()));
            }
            case "DisabledTime": {
                return Optional.ofNullable(clazz.cast(this.disabledTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoreSuccessItem, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoreSuccessItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private String availabilityZone;
        private String state;
        private String stateTransitionReason;
        private String ownerId;
        private String ownerAlias;
        private Instant enablingTime;
        private Instant optimizingTime;
        private Instant enabledTime;
        private Instant disablingTime;
        private Instant disabledTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoreSuccessItem model) {
            this.snapshotId(model.snapshotId);
            this.availabilityZone(model.availabilityZone);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.ownerId(model.ownerId);
            this.ownerAlias(model.ownerAlias);
            this.enablingTime(model.enablingTime);
            this.optimizingTime(model.optimizingTime);
            this.enabledTime(model.enabledTime);
            this.disablingTime(model.disablingTime);
            this.disabledTime(model.disabledTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FastSnapshotRestoreStateCode state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Instant getEnablingTime() {
            return this.enablingTime;
        }

        @Override
        public final Builder enablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
            return this;
        }

        public final void setEnablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
        }

        public final Instant getOptimizingTime() {
            return this.optimizingTime;
        }

        @Override
        public final Builder optimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
            return this;
        }

        public final void setOptimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
        }

        public final Instant getEnabledTime() {
            return this.enabledTime;
        }

        @Override
        public final Builder enabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
            return this;
        }

        public final void setEnabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
        }

        public final Instant getDisablingTime() {
            return this.disablingTime;
        }

        @Override
        public final Builder disablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
            return this;
        }

        public final void setDisablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
        }

        public final Instant getDisabledTime() {
            return this.disabledTime;
        }

        @Override
        public final Builder disabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
            return this;
        }

        public final void setDisabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
        }

        public DisableFastSnapshotRestoreSuccessItem build() {
            return new DisableFastSnapshotRestoreSuccessItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisableFastSnapshotRestoreSuccessItem> {
        public Builder snapshotId(String var1);

        public Builder availabilityZone(String var1);

        public Builder state(String var1);

        public Builder state(FastSnapshotRestoreStateCode var1);

        public Builder stateTransitionReason(String var1);

        public Builder ownerId(String var1);

        public Builder ownerAlias(String var1);

        public Builder enablingTime(Instant var1);

        public Builder optimizingTime(Instant var1);

        public Builder enabledTime(Instant var1);

        public Builder disablingTime(Instant var1);

        public Builder disabledTime(Instant var1);
    }
}

