/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationUsageStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationOptions> {
    private static final SdkField<String> USAGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CapacityReservationOptions.getter(CapacityReservationOptions::usageStrategyAsString)).setter(CapacityReservationOptions.setter(Builder::usageStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageStrategy").unmarshallLocationName("usageStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String usageStrategy;

    private CapacityReservationOptions(BuilderImpl builder) {
        this.usageStrategy = builder.usageStrategy;
    }

    public FleetCapacityReservationUsageStrategy usageStrategy() {
        return FleetCapacityReservationUsageStrategy.fromValue(this.usageStrategy);
    }

    public String usageStrategyAsString() {
        return this.usageStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationOptions)) {
            return false;
        }
        CapacityReservationOptions other = (CapacityReservationOptions)obj;
        return Objects.equals(this.usageStrategyAsString(), other.usageStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"CapacityReservationOptions").add("UsageStrategy", (Object)this.usageStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageStrategy": {
                return Optional.ofNullable(clazz.cast(this.usageStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationOptions, T> g) {
        return obj -> g.apply((CapacityReservationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usageStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationOptions model) {
            this.usageStrategy(model.usageStrategy);
        }

        public final String getUsageStrategyAsString() {
            return this.usageStrategy;
        }

        @Override
        public final Builder usageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
            return this;
        }

        @Override
        public final Builder usageStrategy(FleetCapacityReservationUsageStrategy usageStrategy) {
            this.usageStrategy(usageStrategy == null ? null : usageStrategy.toString());
            return this;
        }

        public final void setUsageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
        }

        public CapacityReservationOptions build() {
            return new CapacityReservationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationOptions> {
        public Builder usageStrategy(String var1);

        public Builder usageStrategy(FleetCapacityReservationUsageStrategy var1);
    }
}

