/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.NewDhcpConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDhcpOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateDhcpOptionsRequest> {
    private static final SdkField<List<NewDhcpConfiguration>> DHCP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDhcpOptionsRequest.getter(CreateDhcpOptionsRequest::dhcpConfigurations)).setter(CreateDhcpOptionsRequest.setter(Builder::dhcpConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpConfiguration").unmarshallLocationName("dhcpConfiguration").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NewDhcpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_CONFIGURATIONS_FIELD));
    private final List<NewDhcpConfiguration> dhcpConfigurations;

    private CreateDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpConfigurations = builder.dhcpConfigurations;
    }

    public boolean hasDhcpConfigurations() {
        return this.dhcpConfigurations != null && !(this.dhcpConfigurations instanceof SdkAutoConstructList);
    }

    public List<NewDhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest)((Object)obj);
        return Objects.equals(this.dhcpConfigurations(), other.dhcpConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"CreateDhcpOptionsRequest").add("DhcpConfigurations", this.dhcpConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dhcpConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDhcpOptionsRequest, T> g) {
        return obj -> g.apply((CreateDhcpOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<NewDhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsRequest model) {
            super(model);
            this.dhcpConfigurations(model.dhcpConfigurations);
        }

        public final Collection<NewDhcpConfiguration.Builder> getDhcpConfigurations() {
            return this.dhcpConfigurations != null ? (Collection)this.dhcpConfigurations.stream().map(NewDhcpConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<NewDhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(NewDhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<NewDhcpConfiguration.Builder> ... dhcpConfigurations) {
            this.dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> (NewDhcpConfiguration)((NewDhcpConfiguration.Builder)NewDhcpConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<NewDhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDhcpOptionsRequest build() {
            return new CreateDhcpOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDhcpOptionsRequest> {
        public Builder dhcpConfigurations(Collection<NewDhcpConfiguration> var1);

        public Builder dhcpConfigurations(NewDhcpConfiguration ... var1);

        public Builder dhcpConfigurations(Consumer<NewDhcpConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

