/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointConnectionNotificationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointConnectionNotificationRequest> {
    private static final SdkField<String> CONNECTION_NOTIFICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcEndpointConnectionNotificationRequest.getter(ModifyVpcEndpointConnectionNotificationRequest::connectionNotificationId)).setter(ModifyVpcEndpointConnectionNotificationRequest.setter(Builder::connectionNotificationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId").unmarshallLocationName("ConnectionNotificationId").build()}).build();
    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcEndpointConnectionNotificationRequest.getter(ModifyVpcEndpointConnectionNotificationRequest::connectionNotificationArn)).setter(ModifyVpcEndpointConnectionNotificationRequest.setter(Builder::connectionNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn").unmarshallLocationName("ConnectionNotificationArn").build()}).build();
    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointConnectionNotificationRequest.getter(ModifyVpcEndpointConnectionNotificationRequest::connectionEvents)).setter(ModifyVpcEndpointConnectionNotificationRequest.setter(Builder::connectionEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents").unmarshallLocationName("ConnectionEvents").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NOTIFICATION_ID_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD));
    private final String connectionNotificationId;
    private final String connectionNotificationArn;
    private final List<String> connectionEvents;

    private ModifyVpcEndpointConnectionNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationId = builder.connectionNotificationId;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
    }

    public String connectionNotificationId() {
        return this.connectionNotificationId;
    }

    public String connectionNotificationArn() {
        return this.connectionNotificationArn;
    }

    public boolean hasConnectionEvents() {
        return this.connectionEvents != null && !(this.connectionEvents instanceof SdkAutoConstructList);
    }

    public List<String> connectionEvents() {
        return this.connectionEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionEvents());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointConnectionNotificationRequest)) {
            return false;
        }
        ModifyVpcEndpointConnectionNotificationRequest other = (ModifyVpcEndpointConnectionNotificationRequest)((Object)obj);
        return Objects.equals(this.connectionNotificationId(), other.connectionNotificationId()) && Objects.equals(this.connectionNotificationArn(), other.connectionNotificationArn()) && Objects.equals(this.connectionEvents(), other.connectionEvents());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcEndpointConnectionNotificationRequest").add("ConnectionNotificationId", (Object)this.connectionNotificationId()).add("ConnectionNotificationArn", (Object)this.connectionNotificationArn()).add("ConnectionEvents", this.connectionEvents()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationId": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationId()));
            }
            case "ConnectionNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationArn()));
            }
            case "ConnectionEvents": {
                return Optional.ofNullable(clazz.cast(this.connectionEvents()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointConnectionNotificationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointConnectionNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String connectionNotificationId;
        private String connectionNotificationArn;
        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointConnectionNotificationRequest model) {
            super(model);
            this.connectionNotificationId(model.connectionNotificationId);
            this.connectionNotificationArn(model.connectionNotificationArn);
            this.connectionEvents(model.connectionEvents);
        }

        public final String getConnectionNotificationId() {
            return this.connectionNotificationId;
        }

        @Override
        public final Builder connectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
            return this;
        }

        public final void setConnectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
        }

        public final String getConnectionNotificationArn() {
            return this.connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        public final Collection<String> getConnectionEvents() {
            return this.connectionEvents;
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String ... connectionEvents) {
            this.connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointConnectionNotificationRequest build() {
            return new ModifyVpcEndpointConnectionNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointConnectionNotificationRequest> {
        public Builder connectionNotificationId(String var1);

        public Builder connectionNotificationArn(String var1);

        public Builder connectionEvents(Collection<String> var1);

        public Builder connectionEvents(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

