/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType;
import software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpnAuthenticationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpnAuthenticationRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnAuthenticationRequest.getter(ClientVpnAuthenticationRequest::typeAsString)).setter(ClientVpnAuthenticationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<DirectoryServiceAuthenticationRequest> ACTIVE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClientVpnAuthenticationRequest.getter(ClientVpnAuthenticationRequest::activeDirectory)).setter(ClientVpnAuthenticationRequest.setter(Builder::activeDirectory)).constructor(DirectoryServiceAuthenticationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory").unmarshallLocationName("ActiveDirectory").build()}).build();
    private static final SdkField<CertificateAuthenticationRequest> MUTUAL_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClientVpnAuthenticationRequest.getter(ClientVpnAuthenticationRequest::mutualAuthentication)).setter(ClientVpnAuthenticationRequest.setter(Builder::mutualAuthentication)).constructor(CertificateAuthenticationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication").unmarshallLocationName("MutualAuthentication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final DirectoryServiceAuthenticationRequest activeDirectory;
    private final CertificateAuthenticationRequest mutualAuthentication;

    private ClientVpnAuthenticationRequest(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
    }

    public ClientVpnAuthenticationType type() {
        return ClientVpnAuthenticationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public DirectoryServiceAuthenticationRequest activeDirectory() {
        return this.activeDirectory;
    }

    public CertificateAuthenticationRequest mutualAuthentication() {
        return this.mutualAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualAuthentication());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnAuthenticationRequest)) {
            return false;
        }
        ClientVpnAuthenticationRequest other = (ClientVpnAuthenticationRequest)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.activeDirectory(), other.activeDirectory()) && Objects.equals(this.mutualAuthentication(), other.mutualAuthentication());
    }

    public String toString() {
        return ToString.builder((String)"ClientVpnAuthenticationRequest").add("Type", (Object)this.typeAsString()).add("ActiveDirectory", (Object)this.activeDirectory()).add("MutualAuthentication", (Object)this.mutualAuthentication()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ActiveDirectory": {
                return Optional.ofNullable(clazz.cast(this.activeDirectory()));
            }
            case "MutualAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualAuthentication()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnAuthenticationRequest, T> g) {
        return obj -> g.apply((ClientVpnAuthenticationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private DirectoryServiceAuthenticationRequest activeDirectory;
        private CertificateAuthenticationRequest mutualAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnAuthenticationRequest model) {
            this.type(model.type);
            this.activeDirectory(model.activeDirectory);
            this.mutualAuthentication(model.mutualAuthentication);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientVpnAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final DirectoryServiceAuthenticationRequest.Builder getActiveDirectory() {
            return this.activeDirectory != null ? this.activeDirectory.toBuilder() : null;
        }

        @Override
        public final Builder activeDirectory(DirectoryServiceAuthenticationRequest activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final void setActiveDirectory(DirectoryServiceAuthenticationRequest.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        public final CertificateAuthenticationRequest.Builder getMutualAuthentication() {
            return this.mutualAuthentication != null ? this.mutualAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder mutualAuthentication(CertificateAuthenticationRequest mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final void setMutualAuthentication(CertificateAuthenticationRequest.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        public ClientVpnAuthenticationRequest build() {
            return new ClientVpnAuthenticationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpnAuthenticationRequest> {
        public Builder type(String var1);

        public Builder type(ClientVpnAuthenticationType var1);

        public Builder activeDirectory(DirectoryServiceAuthenticationRequest var1);

        default public Builder activeDirectory(Consumer<DirectoryServiceAuthenticationRequest.Builder> activeDirectory) {
            return this.activeDirectory((DirectoryServiceAuthenticationRequest)((DirectoryServiceAuthenticationRequest.Builder)DirectoryServiceAuthenticationRequest.builder().applyMutation(activeDirectory)).build());
        }

        public Builder mutualAuthentication(CertificateAuthenticationRequest var1);

        default public Builder mutualAuthentication(Consumer<CertificateAuthenticationRequest.Builder> mutualAuthentication) {
            return this.mutualAuthentication((CertificateAuthenticationRequest)((CertificateAuthenticationRequest.Builder)CertificateAuthenticationRequest.builder().applyMutation(mutualAuthentication)).build());
        }
    }
}

