/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VgwTelemetryListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptions;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.model.VpnStaticRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnection> {
    private static final SdkField<String> CUSTOMER_GATEWAY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::customerGatewayConfiguration)).setter(VpnConnection.setter(Builder::customerGatewayConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayConfiguration").unmarshallLocationName("customerGatewayConfiguration").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::customerGatewayId)).setter(VpnConnection.setter(Builder::customerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("customerGatewayId").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::category)).setter(VpnConnection.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").unmarshallLocationName("category").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::stateAsString)).setter(VpnConnection.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::typeAsString)).setter(VpnConnection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::vpnConnectionId)).setter(VpnConnection.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("vpnConnectionId").build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::vpnGatewayId)).setter(VpnConnection.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("vpnGatewayId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpnConnection.getter(VpnConnection::transitGatewayId)).setter(VpnConnection.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<VpnConnectionOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VpnConnection.getter(VpnConnection::options)).setter(VpnConnection.setter(Builder::options)).constructor(VpnConnectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("options").build()}).build();
    private static final SdkField<List<VpnStaticRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnConnection.getter(VpnConnection::routes)).setter(VpnConnection.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").unmarshallLocationName("routes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnStaticRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnConnection.getter(VpnConnection::tags)).setter(VpnConnection.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<VgwTelemetry>> VGW_TELEMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnConnection.getter(VpnConnection::vgwTelemetry)).setter(VpnConnection.setter(Builder::vgwTelemetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VgwTelemetry").unmarshallLocationName("vgwTelemetry").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VgwTelemetry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_CONFIGURATION_FIELD, CUSTOMER_GATEWAY_ID_FIELD, CATEGORY_FIELD, STATE_FIELD, TYPE_FIELD, VPN_CONNECTION_ID_FIELD, VPN_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, OPTIONS_FIELD, ROUTES_FIELD, TAGS_FIELD, VGW_TELEMETRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customerGatewayConfiguration;
    private final String customerGatewayId;
    private final String category;
    private final String state;
    private final String type;
    private final String vpnConnectionId;
    private final String vpnGatewayId;
    private final String transitGatewayId;
    private final VpnConnectionOptions options;
    private final List<VpnStaticRoute> routes;
    private final List<Tag> tags;
    private final List<VgwTelemetry> vgwTelemetry;

    private VpnConnection(BuilderImpl builder) {
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.customerGatewayId = builder.customerGatewayId;
        this.category = builder.category;
        this.state = builder.state;
        this.type = builder.type;
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.options = builder.options;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vgwTelemetry = builder.vgwTelemetry;
    }

    public String customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String category() {
        return this.category;
    }

    public VpnState state() {
        return VpnState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public String transitGatewayId() {
        return this.transitGatewayId;
    }

    public VpnConnectionOptions options() {
        return this.options;
    }

    public boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public List<VpnStaticRoute> routes() {
        return this.routes;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasVgwTelemetry() {
        return this.vgwTelemetry != null && !(this.vgwTelemetry instanceof SdkAutoConstructList);
    }

    public List<VgwTelemetry> vgwTelemetry() {
        return this.vgwTelemetry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.routes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vgwTelemetry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection)obj;
        return Objects.equals(this.customerGatewayConfiguration(), other.customerGatewayConfiguration()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vgwTelemetry(), other.vgwTelemetry());
    }

    public String toString() {
        return ToString.builder((String)"VpnConnection").add("CustomerGatewayConfiguration", (Object)this.customerGatewayConfiguration()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("Category", (Object)this.category()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).add("VpnConnectionId", (Object)this.vpnConnectionId()).add("VpnGatewayId", (Object)this.vpnGatewayId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("Options", (Object)this.options()).add("Routes", this.routes()).add("Tags", this.tags()).add("VgwTelemetry", this.vgwTelemetry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayConfiguration()));
            }
            case "CustomerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayId()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VgwTelemetry": {
                return Optional.ofNullable(clazz.cast(this.vgwTelemetry()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnection, T> g) {
        return obj -> g.apply((VpnConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerGatewayConfiguration;
        private String customerGatewayId;
        private String category;
        private String state;
        private String type;
        private String vpnConnectionId;
        private String vpnGatewayId;
        private String transitGatewayId;
        private VpnConnectionOptions options;
        private List<VpnStaticRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<VgwTelemetry> vgwTelemetry = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnection model) {
            this.customerGatewayConfiguration(model.customerGatewayConfiguration);
            this.customerGatewayId(model.customerGatewayId);
            this.category(model.category);
            this.state(model.state);
            this.type(model.type);
            this.vpnConnectionId(model.vpnConnectionId);
            this.vpnGatewayId(model.vpnGatewayId);
            this.transitGatewayId(model.transitGatewayId);
            this.options(model.options);
            this.routes(model.routes);
            this.tags(model.tags);
            this.vgwTelemetry(model.vgwTelemetry);
        }

        public final String getCustomerGatewayConfiguration() {
            return this.customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final VpnConnectionOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<VpnStaticRoute.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(VpnStaticRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VpnStaticRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<VpnStaticRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (VpnStaticRoute)((VpnStaticRoute.Builder)VpnStaticRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<VpnStaticRoute.BuilderImpl> routes) {
            this.routes = VpnStaticRouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<VgwTelemetry.Builder> getVgwTelemetry() {
            return this.vgwTelemetry != null ? (Collection)this.vgwTelemetry.stream().map(VgwTelemetry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(VgwTelemetry ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(Consumer<VgwTelemetry.Builder> ... vgwTelemetry) {
            this.vgwTelemetry(Stream.of(vgwTelemetry).map(c -> (VgwTelemetry)((VgwTelemetry.Builder)VgwTelemetry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVgwTelemetry(Collection<VgwTelemetry.BuilderImpl> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copyFromBuilder(vgwTelemetry);
        }

        public VpnConnection build() {
            return new VpnConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnection> {
        public Builder customerGatewayConfiguration(String var1);

        public Builder customerGatewayId(String var1);

        public Builder category(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder vpnConnectionId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder options(VpnConnectionOptions var1);

        default public Builder options(Consumer<VpnConnectionOptions.Builder> options) {
            return this.options((VpnConnectionOptions)((VpnConnectionOptions.Builder)VpnConnectionOptions.builder().applyMutation(options)).build());
        }

        public Builder routes(Collection<VpnStaticRoute> var1);

        public Builder routes(VpnStaticRoute ... var1);

        public Builder routes(Consumer<VpnStaticRoute.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vgwTelemetry(Collection<VgwTelemetry> var1);

        public Builder vgwTelemetry(VgwTelemetry ... var1);

        public Builder vgwTelemetry(Consumer<VgwTelemetry.Builder> ... var1);
    }
}

