/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BundleTaskState {
    PENDING("pending"),
    WAITING_FOR_SHUTDOWN("waiting-for-shutdown"),
    BUNDLING("bundling"),
    STORING("storing"),
    CANCELLING("cancelling"),
    COMPLETE("complete"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BundleTaskState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BundleTaskState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BundleTaskState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BundleTaskState> knownValues() {
        return Stream.of(BundleTaskState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

