/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationState;
import software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.AvailableCapacity;
import software.amazon.awssdk.services.ec2.model.HostInstance;
import software.amazon.awssdk.services.ec2.model.HostInstanceListCopier;
import software.amazon.awssdk.services.ec2.model.HostProperties;
import software.amazon.awssdk.services.ec2.model.HostRecovery;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Host
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Host> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::autoPlacementAsString)).setter(Host.setter(Builder::autoPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement").unmarshallLocationName("autoPlacement").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::availabilityZone)).setter(Host.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<AvailableCapacity> AVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Host.getter(Host::availableCapacity)).setter(Host.setter(Builder::availableCapacity)).constructor(AvailableCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCapacity").unmarshallLocationName("availableCapacity").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::clientToken)).setter(Host.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::hostId)).setter(Host.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build()}).build();
    private static final SdkField<HostProperties> HOST_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Host.getter(Host::hostProperties)).setter(Host.setter(Builder::hostProperties)).constructor(HostProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostProperties").unmarshallLocationName("hostProperties").build()}).build();
    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::hostReservationId)).setter(Host.setter(Builder::hostReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId").unmarshallLocationName("hostReservationId").build()}).build();
    private static final SdkField<List<HostInstance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Host.getter(Host::instances)).setter(Host.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").unmarshallLocationName("instances").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::stateAsString)).setter(Host.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> ALLOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Host.getter(Host::allocationTime)).setter(Host.setter(Builder::allocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationTime").unmarshallLocationName("allocationTime").build()}).build();
    private static final SdkField<Instant> RELEASE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Host.getter(Host::releaseTime)).setter(Host.setter(Builder::releaseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseTime").unmarshallLocationName("releaseTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Host.getter(Host::tags)).setter(Host.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::hostRecoveryAsString)).setter(Host.setter(Builder::hostRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRecovery").unmarshallLocationName("hostRecovery").build()}).build();
    private static final SdkField<String> ALLOWS_MULTIPLE_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::allowsMultipleInstanceTypesAsString)).setter(Host.setter(Builder::allowsMultipleInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowsMultipleInstanceTypes").unmarshallLocationName("allowsMultipleInstanceTypes").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::ownerId)).setter(Host.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Host.getter(Host::availabilityZoneId)).setter(Host.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABLE_CAPACITY_FIELD, CLIENT_TOKEN_FIELD, HOST_ID_FIELD, HOST_PROPERTIES_FIELD, HOST_RESERVATION_ID_FIELD, INSTANCES_FIELD, STATE_FIELD, ALLOCATION_TIME_FIELD, RELEASE_TIME_FIELD, TAGS_FIELD, HOST_RECOVERY_FIELD, ALLOWS_MULTIPLE_INSTANCE_TYPES_FIELD, OWNER_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoPlacement;
    private final String availabilityZone;
    private final AvailableCapacity availableCapacity;
    private final String clientToken;
    private final String hostId;
    private final HostProperties hostProperties;
    private final String hostReservationId;
    private final List<HostInstance> instances;
    private final String state;
    private final Instant allocationTime;
    private final Instant releaseTime;
    private final List<Tag> tags;
    private final String hostRecovery;
    private final String allowsMultipleInstanceTypes;
    private final String ownerId;
    private final String availabilityZoneId;

    private Host(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.availableCapacity = builder.availableCapacity;
        this.clientToken = builder.clientToken;
        this.hostId = builder.hostId;
        this.hostProperties = builder.hostProperties;
        this.hostReservationId = builder.hostReservationId;
        this.instances = builder.instances;
        this.state = builder.state;
        this.allocationTime = builder.allocationTime;
        this.releaseTime = builder.releaseTime;
        this.tags = builder.tags;
        this.hostRecovery = builder.hostRecovery;
        this.allowsMultipleInstanceTypes = builder.allowsMultipleInstanceTypes;
        this.ownerId = builder.ownerId;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public AvailableCapacity availableCapacity() {
        return this.availableCapacity;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String hostId() {
        return this.hostId;
    }

    public HostProperties hostProperties() {
        return this.hostProperties;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public List<HostInstance> instances() {
        return this.instances;
    }

    public AllocationState state() {
        return AllocationState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant allocationTime() {
        return this.allocationTime;
    }

    public Instant releaseTime() {
        return this.releaseTime;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public HostRecovery hostRecovery() {
        return HostRecovery.fromValue(this.hostRecovery);
    }

    public String hostRecoveryAsString() {
        return this.hostRecovery;
    }

    public AllowsMultipleInstanceTypes allowsMultipleInstanceTypes() {
        return AllowsMultipleInstanceTypes.fromValue(this.allowsMultipleInstanceTypes);
    }

    public String allowsMultipleInstanceTypesAsString() {
        return this.allowsMultipleInstanceTypes;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsMultipleInstanceTypesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availableCapacity(), other.availableCapacity()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.hostProperties(), other.hostProperties()) && Objects.equals(this.hostReservationId(), other.hostReservationId()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.allocationTime(), other.allocationTime()) && Objects.equals(this.releaseTime(), other.releaseTime()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.hostRecoveryAsString(), other.hostRecoveryAsString()) && Objects.equals(this.allowsMultipleInstanceTypesAsString(), other.allowsMultipleInstanceTypesAsString()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId());
    }

    public String toString() {
        return ToString.builder((String)"Host").add("AutoPlacement", (Object)this.autoPlacementAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailableCapacity", (Object)this.availableCapacity()).add("ClientToken", (Object)this.clientToken()).add("HostId", (Object)this.hostId()).add("HostProperties", (Object)this.hostProperties()).add("HostReservationId", (Object)this.hostReservationId()).add("Instances", this.instances()).add("State", (Object)this.stateAsString()).add("AllocationTime", (Object)this.allocationTime()).add("ReleaseTime", (Object)this.releaseTime()).add("Tags", this.tags()).add("HostRecovery", (Object)this.hostRecoveryAsString()).add("AllowsMultipleInstanceTypes", (Object)this.allowsMultipleInstanceTypesAsString()).add("OwnerId", (Object)this.ownerId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.ofNullable(clazz.cast(this.autoPlacementAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.availableCapacity()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "HostProperties": {
                return Optional.ofNullable(clazz.cast(this.hostProperties()));
            }
            case "HostReservationId": {
                return Optional.ofNullable(clazz.cast(this.hostReservationId()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AllocationTime": {
                return Optional.ofNullable(clazz.cast(this.allocationTime()));
            }
            case "ReleaseTime": {
                return Optional.ofNullable(clazz.cast(this.releaseTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "HostRecovery": {
                return Optional.ofNullable(clazz.cast(this.hostRecoveryAsString()));
            }
            case "AllowsMultipleInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.allowsMultipleInstanceTypesAsString()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoPlacement;
        private String availabilityZone;
        private AvailableCapacity availableCapacity;
        private String clientToken;
        private String hostId;
        private HostProperties hostProperties;
        private String hostReservationId;
        private List<HostInstance> instances = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Instant allocationTime;
        private Instant releaseTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String hostRecovery;
        private String allowsMultipleInstanceTypes;
        private String ownerId;
        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.autoPlacement(model.autoPlacement);
            this.availabilityZone(model.availabilityZone);
            this.availableCapacity(model.availableCapacity);
            this.clientToken(model.clientToken);
            this.hostId(model.hostId);
            this.hostProperties(model.hostProperties);
            this.hostReservationId(model.hostReservationId);
            this.instances(model.instances);
            this.state(model.state);
            this.allocationTime(model.allocationTime);
            this.releaseTime(model.releaseTime);
            this.tags(model.tags);
            this.hostRecovery(model.hostRecovery);
            this.allowsMultipleInstanceTypes(model.allowsMultipleInstanceTypes);
            this.ownerId(model.ownerId);
            this.availabilityZoneId(model.availabilityZoneId);
        }

        public final String getAutoPlacementAsString() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement == null ? null : autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AvailableCapacity.Builder getAvailableCapacity() {
            return this.availableCapacity != null ? this.availableCapacity.toBuilder() : null;
        }

        @Override
        public final Builder availableCapacity(AvailableCapacity availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(AvailableCapacity.BuilderImpl availableCapacity) {
            this.availableCapacity = availableCapacity != null ? availableCapacity.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final HostProperties.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        @Override
        public final Builder hostProperties(HostProperties hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final void setHostProperties(HostProperties.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final Collection<HostInstance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(HostInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HostInstance> instances) {
            this.instances = HostInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HostInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HostInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (HostInstance)((HostInstance.Builder)HostInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<HostInstance.BuilderImpl> instances) {
            this.instances = HostInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AllocationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getAllocationTime() {
            return this.allocationTime;
        }

        @Override
        public final Builder allocationTime(Instant allocationTime) {
            this.allocationTime = allocationTime;
            return this;
        }

        public final void setAllocationTime(Instant allocationTime) {
            this.allocationTime = allocationTime;
        }

        public final Instant getReleaseTime() {
            return this.releaseTime;
        }

        @Override
        public final Builder releaseTime(Instant releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        public final void setReleaseTime(Instant releaseTime) {
            this.releaseTime = releaseTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getHostRecoveryAsString() {
            return this.hostRecovery;
        }

        @Override
        public final Builder hostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        @Override
        public final Builder hostRecovery(HostRecovery hostRecovery) {
            this.hostRecovery(hostRecovery == null ? null : hostRecovery.toString());
            return this;
        }

        public final void setHostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
        }

        public final String getAllowsMultipleInstanceTypesAsString() {
            return this.allowsMultipleInstanceTypes;
        }

        @Override
        public final Builder allowsMultipleInstanceTypes(String allowsMultipleInstanceTypes) {
            this.allowsMultipleInstanceTypes = allowsMultipleInstanceTypes;
            return this;
        }

        @Override
        public final Builder allowsMultipleInstanceTypes(AllowsMultipleInstanceTypes allowsMultipleInstanceTypes) {
            this.allowsMultipleInstanceTypes(allowsMultipleInstanceTypes == null ? null : allowsMultipleInstanceTypes.toString());
            return this;
        }

        public final void setAllowsMultipleInstanceTypes(String allowsMultipleInstanceTypes) {
            this.allowsMultipleInstanceTypes = allowsMultipleInstanceTypes;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public Host build() {
            return new Host(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Host> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder availabilityZone(String var1);

        public Builder availableCapacity(AvailableCapacity var1);

        default public Builder availableCapacity(Consumer<AvailableCapacity.Builder> availableCapacity) {
            return this.availableCapacity((AvailableCapacity)((AvailableCapacity.Builder)AvailableCapacity.builder().applyMutation(availableCapacity)).build());
        }

        public Builder clientToken(String var1);

        public Builder hostId(String var1);

        public Builder hostProperties(HostProperties var1);

        default public Builder hostProperties(Consumer<HostProperties.Builder> hostProperties) {
            return this.hostProperties((HostProperties)((HostProperties.Builder)HostProperties.builder().applyMutation(hostProperties)).build());
        }

        public Builder hostReservationId(String var1);

        public Builder instances(Collection<HostInstance> var1);

        public Builder instances(HostInstance ... var1);

        public Builder instances(Consumer<HostInstance.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(AllocationState var1);

        public Builder allocationTime(Instant var1);

        public Builder releaseTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder hostRecovery(String var1);

        public Builder hostRecovery(HostRecovery var1);

        public Builder allowsMultipleInstanceTypes(String var1);

        public Builder allowsMultipleInstanceTypes(AllowsMultipleInstanceTypes var1);

        public Builder ownerId(String var1);

        public Builder availabilityZoneId(String var1);
    }
}

