/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.StaleIpPermission;
import software.amazon.awssdk.services.ec2.model.StaleIpPermissionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaleSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaleSecurityGroup> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StaleSecurityGroup.getter(StaleSecurityGroup::description)).setter(StaleSecurityGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StaleSecurityGroup.getter(StaleSecurityGroup::groupId)).setter(StaleSecurityGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StaleSecurityGroup.getter(StaleSecurityGroup::groupName)).setter(StaleSecurityGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<List<StaleIpPermission>> STALE_IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StaleSecurityGroup.getter(StaleSecurityGroup::staleIpPermissions)).setter(StaleSecurityGroup.setter(Builder::staleIpPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleIpPermissions").unmarshallLocationName("staleIpPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaleIpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<StaleIpPermission>> STALE_IP_PERMISSIONS_EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StaleSecurityGroup.getter(StaleSecurityGroup::staleIpPermissionsEgress)).setter(StaleSecurityGroup.setter(Builder::staleIpPermissionsEgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleIpPermissionsEgress").unmarshallLocationName("staleIpPermissionsEgress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaleIpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StaleSecurityGroup.getter(StaleSecurityGroup::vpcId)).setter(StaleSecurityGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD, STALE_IP_PERMISSIONS_FIELD, STALE_IP_PERMISSIONS_EGRESS_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String groupId;
    private final String groupName;
    private final List<StaleIpPermission> staleIpPermissions;
    private final List<StaleIpPermission> staleIpPermissionsEgress;
    private final String vpcId;

    private StaleSecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.staleIpPermissions = builder.staleIpPermissions;
        this.staleIpPermissionsEgress = builder.staleIpPermissionsEgress;
        this.vpcId = builder.vpcId;
    }

    public String description() {
        return this.description;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<StaleIpPermission> staleIpPermissions() {
        return this.staleIpPermissions;
    }

    public List<StaleIpPermission> staleIpPermissionsEgress() {
        return this.staleIpPermissionsEgress;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.staleIpPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.staleIpPermissionsEgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.staleIpPermissions(), other.staleIpPermissions()) && Objects.equals(this.staleIpPermissionsEgress(), other.staleIpPermissionsEgress()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"StaleSecurityGroup").add("Description", (Object)this.description()).add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("StaleIpPermissions", this.staleIpPermissions()).add("StaleIpPermissionsEgress", this.staleIpPermissionsEgress()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "StaleIpPermissions": {
                return Optional.ofNullable(clazz.cast(this.staleIpPermissions()));
            }
            case "StaleIpPermissionsEgress": {
                return Optional.ofNullable(clazz.cast(this.staleIpPermissionsEgress()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaleSecurityGroup, T> g) {
        return obj -> g.apply((StaleSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupId;
        private String groupName;
        private List<StaleIpPermission> staleIpPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<StaleIpPermission> staleIpPermissionsEgress = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleSecurityGroup model) {
            this.description(model.description);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.staleIpPermissions(model.staleIpPermissions);
            this.staleIpPermissionsEgress(model.staleIpPermissionsEgress);
            this.vpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissions() {
            return this.staleIpPermissions != null ? (Collection)this.staleIpPermissions.stream().map(StaleIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(StaleIpPermission ... staleIpPermissions) {
            this.staleIpPermissions(Arrays.asList(staleIpPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(Consumer<StaleIpPermission.Builder> ... staleIpPermissions) {
            this.staleIpPermissions(Stream.of(staleIpPermissions).map(c -> (StaleIpPermission)((StaleIpPermission.Builder)StaleIpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaleIpPermissions(Collection<StaleIpPermission.BuilderImpl> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissions);
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissionsEgress() {
            return this.staleIpPermissionsEgress != null ? (Collection)this.staleIpPermissionsEgress.stream().map(StaleIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(StaleIpPermission ... staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(Consumer<StaleIpPermission.Builder> ... staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress(Stream.of(staleIpPermissionsEgress).map(c -> (StaleIpPermission)((StaleIpPermission.Builder)StaleIpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaleIpPermissionsEgress(Collection<StaleIpPermission.BuilderImpl> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissionsEgress);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public StaleSecurityGroup build() {
            return new StaleSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaleSecurityGroup> {
        public Builder description(String var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder staleIpPermissions(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissions(StaleIpPermission ... var1);

        public Builder staleIpPermissions(Consumer<StaleIpPermission.Builder> ... var1);

        public Builder staleIpPermissionsEgress(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissionsEgress(StaleIpPermission ... var1);

        public Builder staleIpPermissionsEgress(Consumer<StaleIpPermission.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

