/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;

public class DescribeInstanceStatusIterable
implements SdkIterable<DescribeInstanceStatusResponse> {
    private final Ec2Client client;
    private final DescribeInstanceStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceStatusIterable(Ec2Client client, DescribeInstanceStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceStatusResponseFetcher();
    }

    public Iterator<DescribeInstanceStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceStatus> instanceStatuses() {
        Function<DescribeInstanceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceStatuses() != null) {
                return response.instanceStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeInstanceStatusIterable resume(DescribeInstanceStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstanceStatusIterable(this.client, (DescribeInstanceStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstanceStatusIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeInstanceStatusResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeInstanceStatusResponseFetcher
    implements SyncPageFetcher<DescribeInstanceStatusResponse> {
        private DescribeInstanceStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceStatusResponse nextPage(DescribeInstanceStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceStatusIterable.this.client.describeInstanceStatus(DescribeInstanceStatusIterable.this.firstRequest);
            }
            return DescribeInstanceStatusIterable.this.client.describeInstanceStatus((DescribeInstanceStatusRequest)((Object)DescribeInstanceStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

