/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::destinationCidrBlock)).setter(ReplaceRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::destinationIpv6CidrBlock)).setter(ReplaceRouteRequest.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").unmarshallLocationName("destinationIpv6CidrBlock").build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::egressOnlyInternetGatewayId)).setter(ReplaceRouteRequest.setter(Builder::egressOnlyInternetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId").unmarshallLocationName("egressOnlyInternetGatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::gatewayId)).setter(ReplaceRouteRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").unmarshallLocationName("gatewayId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::instanceId)).setter(ReplaceRouteRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::natGatewayId)).setter(ReplaceRouteRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::networkInterfaceId)).setter(ReplaceRouteRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::routeTableId)).setter(ReplaceRouteRequest.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceRouteRequest.getter(ReplaceRouteRequest::vpcPeeringConnectionId)).setter(ReplaceRouteRequest.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, NAT_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ROUTE_TABLE_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;
    private final String egressOnlyInternetGatewayId;
    private final String gatewayId;
    private final String instanceId;
    private final String natGatewayId;
    private final String networkInterfaceId;
    private final String routeTableId;
    private final String vpcPeeringConnectionId;

    private ReplaceRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.routeTableId = builder.routeTableId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String natGatewayId() {
        return this.natGatewayId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRouteRequest)) {
            return false;
        }
        ReplaceRouteRequest other = (ReplaceRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"ReplaceRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).add("GatewayId", (Object)this.gatewayId()).add("InstanceId", (Object)this.instanceId()).add("NatGatewayId", (Object)this.natGatewayId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("RouteTableId", (Object)this.routeTableId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRouteRequest, T> g) {
        return obj -> g.apply((ReplaceRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;
        private String egressOnlyInternetGatewayId;
        private String gatewayId;
        private String instanceId;
        private String natGatewayId;
        private String networkInterfaceId;
        private String routeTableId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            this.gatewayId(model.gatewayId);
            this.instanceId(model.instanceId);
            this.natGatewayId(model.natGatewayId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.routeTableId(model.routeTableId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceRouteRequest build() {
            return new ReplaceRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder egressOnlyInternetGatewayId(String var1);

        public Builder gatewayId(String var1);

        public Builder instanceId(String var1);

        public Builder natGatewayId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder routeTableId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

