/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;

public class CreateKeyPairRequestMarshaller
implements Marshaller<Request<CreateKeyPairRequest>, CreateKeyPairRequest> {
    public Request<CreateKeyPairRequest> marshall(CreateKeyPairRequest createKeyPairRequest) {
        if (createKeyPairRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createKeyPairRequest, "EC2Client");
        request.addParameter("Action", "CreateKeyPair");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createKeyPairRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)createKeyPairRequest.keyName()));
        }
        return request;
    }
}

