/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;

public class DescribeReservedInstancesModificationsIterable
implements SdkIterable<DescribeReservedInstancesModificationsResponse> {
    private final EC2Client client;
    private final DescribeReservedInstancesModificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedInstancesModificationsIterable(EC2Client client, DescribeReservedInstancesModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesModificationsResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesModificationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedInstancesModification> reservedInstancesModifications() {
        Function<DescribeReservedInstancesModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesModifications() != null) {
                return response.reservedInstancesModifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedInstancesModificationsIterable resume(DescribeReservedInstancesModificationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedInstancesModificationsIterable(this.client, (DescribeReservedInstancesModificationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedInstancesModificationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedInstancesModificationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedInstancesModificationsResponseFetcher
    implements SyncPageFetcher<DescribeReservedInstancesModificationsResponse> {
        private DescribeReservedInstancesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeReservedInstancesModificationsResponse nextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesModificationsIterable.this.client.describeReservedInstancesModifications(DescribeReservedInstancesModificationsIterable.this.firstRequest);
            }
            return DescribeReservedInstancesModificationsIterable.this.client.describeReservedInstancesModifications((DescribeReservedInstancesModificationsRequest)((Object)DescribeReservedInstancesModificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

