/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Filter
implements ToCopyableBuilder<Builder, Filter> {
    private final String name;
    private final List<String> values;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
    }

    public String name() {
        return this.name;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"Filter").add("Name", (Object)this.name()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.name(model.name);
            this.values(model.values);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
        }

        public Filter build() {
            return new Filter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Filter> {
        public Builder name(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

