/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ExportTaskState;
import software.amazon.awssdk.services.ec2.model.ExportToS3Task;
import software.amazon.awssdk.services.ec2.model.InstanceExportDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportTask
implements ToCopyableBuilder<Builder, ExportTask> {
    private final String description;
    private final String exportTaskId;
    private final ExportToS3Task exportToS3Task;
    private final InstanceExportDetails instanceExportDetails;
    private final String state;
    private final String statusMessage;

    private ExportTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportTaskId = builder.exportTaskId;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceExportDetails = builder.instanceExportDetails;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    public String description() {
        return this.description;
    }

    public String exportTaskId() {
        return this.exportTaskId;
    }

    public ExportToS3Task exportToS3Task() {
        return this.exportToS3Task;
    }

    public InstanceExportDetails instanceExportDetails() {
        return this.instanceExportDetails;
    }

    public ExportTaskState state() {
        return ExportTaskState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceExportDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.exportTaskId(), other.exportTaskId()) && Objects.equals(this.exportToS3Task(), other.exportToS3Task()) && Objects.equals(this.instanceExportDetails(), other.instanceExportDetails()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ExportTask").add("Description", (Object)this.description()).add("ExportTaskId", (Object)this.exportTaskId()).add("ExportToS3Task", (Object)this.exportToS3Task()).add("InstanceExportDetails", (Object)this.instanceExportDetails()).add("State", (Object)this.stateString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ExportTaskId": {
                return Optional.of(clazz.cast(this.exportTaskId()));
            }
            case "ExportToS3Task": {
                return Optional.of(clazz.cast(this.exportToS3Task()));
            }
            case "InstanceExportDetails": {
                return Optional.of(clazz.cast(this.instanceExportDetails()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String exportTaskId;
        private ExportToS3Task exportToS3Task;
        private InstanceExportDetails instanceExportDetails;
        private String state;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.description(model.description);
            this.exportTaskId(model.exportTaskId);
            this.exportToS3Task(model.exportToS3Task);
            this.instanceExportDetails(model.instanceExportDetails);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportTaskId() {
            return this.exportTaskId;
        }

        @Override
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        public final ExportToS3Task.Builder getExportToS3Task() {
            return this.exportToS3Task != null ? this.exportToS3Task.toBuilder() : null;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3Task.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        public final InstanceExportDetails.Builder getInstanceExportDetails() {
            return this.instanceExportDetails != null ? this.instanceExportDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
            return this;
        }

        public final void setInstanceExportDetails(InstanceExportDetails.BuilderImpl instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails != null ? instanceExportDetails.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportTask> {
        public Builder description(String var1);

        public Builder exportTaskId(String var1);

        public Builder exportToS3Task(ExportToS3Task var1);

        default public Builder exportToS3Task(Consumer<ExportToS3Task.Builder> exportToS3Task) {
            return this.exportToS3Task((ExportToS3Task)((ExportToS3Task.Builder)ExportToS3Task.builder().apply(exportToS3Task)).build());
        }

        public Builder instanceExportDetails(InstanceExportDetails var1);

        default public Builder instanceExportDetails(Consumer<InstanceExportDetails.Builder> instanceExportDetails) {
            return this.instanceExportDetails((InstanceExportDetails)((InstanceExportDetails.Builder)InstanceExportDetails.builder().apply(instanceExportDetails)).build());
        }

        public Builder state(String var1);

        public Builder state(ExportTaskState var1);

        public Builder statusMessage(String var1);
    }
}

