/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiskImage
implements ToCopyableBuilder<Builder, DiskImage> {
    private final String description;
    private final DiskImageDetail image;
    private final VolumeDetail volume;

    private DiskImage(BuilderImpl builder) {
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDetail image() {
        return this.image;
    }

    public VolumeDetail volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImage)) {
            return false;
        }
        DiskImage other = (DiskImage)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.volume(), other.volume());
    }

    public String toString() {
        return ToString.builder((String)"DiskImage").add("Description", (Object)this.description()).add("Image", (Object)this.image()).add("Volume", (Object)this.volume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.of(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private DiskImageDetail image;
        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImage model) {
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDetail.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final VolumeDetail.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        public DiskImage build() {
            return new DiskImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskImage> {
        public Builder description(String var1);

        public Builder image(DiskImageDetail var1);

        default public Builder image(Consumer<DiskImageDetail.Builder> image) {
            return this.image((DiskImageDetail)((DiskImageDetail.Builder)DiskImageDetail.builder().apply(image)).build());
        }

        public Builder volume(VolumeDetail var1);

        default public Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return this.volume((VolumeDetail)((VolumeDetail.Builder)VolumeDetail.builder().apply(volume)).build());
        }
    }
}

